/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.components.directvm;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Processor;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.processor.DelegateAsyncProcessor;
import org.qubership.integration.platform.engine.camel.components.directvm.ChainEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ChainProcessor
extends DelegateAsyncProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ChainProcessor.class);
    private final ChainEndpoint endpoint;

    public ChainProcessor(Processor processor, ChainEndpoint endpoint) {
        super(processor);
        this.endpoint = endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(Exchange exchange, AsyncCallback callback) {
        Exchange copy = this.prepareExchange(exchange);
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        boolean changed = false;
        try {
            ClassLoader appClassLoader = this.endpoint.getCamelContext().getApplicationContextClassLoader();
            if (appClassLoader != null) {
                LOG.trace("Setting Thread ContextClassLoader to {}", (Object)appClassLoader);
                Thread.currentThread().setContextClassLoader(appClassLoader);
                changed = true;
            }
            boolean chgd = changed;
            boolean bl = this.processor.process(copy, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            return bl;
        }
        finally {
            if (changed) {
                LOG.trace("Restoring Thread ContextClassLoader to {}", (Object)current);
                Thread.currentThread().setContextClassLoader(current);
            }
        }
    }

    private Exchange prepareExchange(Exchange exchange) {
        Exchange newExchange = ChainProcessor.copyExchangeAndSetCamelContext((Exchange)exchange, (CamelContext)this.endpoint.getCamelContext(), (boolean)false);
        newExchange.getExchangeExtension().setFromEndpoint((Endpoint)this.endpoint);
        if (newExchange.getProperty(ExchangePropertyKey.STREAM_CACHE_UNIT_OF_WORK) == null) {
            newExchange.setProperty(ExchangePropertyKey.STREAM_CACHE_UNIT_OF_WORK, (Object)exchange.getUnitOfWork());
        }
        return newExchange;
    }

    private static Exchange copyExchangeAndSetCamelContext(Exchange exchange, CamelContext context, boolean handover) {
        DefaultExchange answer = new DefaultExchange(context, exchange.getPattern());
        if (exchange.hasProperties()) {
            answer.getExchangeExtension().setProperties(ChainProcessor.safeCopyProperties((Map)exchange.getProperties()));
        }
        exchange.getExchangeExtension().copyInternalProperties((Exchange)answer);
        List history = (List)exchange.getProperty(ExchangePropertyKey.MESSAGE_HISTORY);
        if (history != null) {
            answer.setProperty(ExchangePropertyKey.MESSAGE_HISTORY, new CopyOnWriteArrayList(history));
        }
        if (handover) {
            exchange.getExchangeExtension().handoverCompletions((Exchange)answer);
        }
        answer.setIn(exchange.getIn().copy());
        if (exchange.hasOut()) {
            answer.setOut(exchange.getOut().copy());
        }
        answer.setException((Throwable)exchange.getException());
        return answer;
    }

    private static Map<String, Object> safeCopyProperties(Map<String, Object> properties) {
        if (properties == null) {
            return null;
        }
        return new ConcurrentHashMap<String, Object>(properties);
    }

    public String toString() {
        return "ChainProcessor[" + String.valueOf(this.processor) + "]";
    }
}

