/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.processors;

import java.nio.charset.Charset;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Processor;
import org.apache.camel.support.ExchangeHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.springframework.stereotype.Component;

@Component
public class HttpProducerCharsetProcessor
implements Processor {
    private static final String DEFAULT_REQUEST_CHARSET = "UTF-8";

    public void process(Exchange exchange) throws Exception {
        if (exchange != null) {
            Charset cs;
            if (StringUtils.isNotEmpty((CharSequence)ExchangeHelper.getCharsetName((Exchange)exchange, (boolean)false))) {
                return;
            }
            String contentTypeString = ExchangeHelper.getContentType((Exchange)exchange);
            ContentType contentType = null;
            if (contentTypeString != null) {
                contentType = contentTypeString.indexOf("charset") > 0 || contentTypeString.indexOf(59) > 0 ? ContentType.parse((String)contentTypeString) : ContentType.create((String)contentTypeString);
            }
            if (contentType != null && (cs = contentType.getCharset()) != null && StringUtils.isNotEmpty((CharSequence)cs.name())) {
                return;
            }
            exchange.setProperty(ExchangePropertyKey.CHARSET_NAME, (Object)DEFAULT_REQUEST_CHARSET);
        }
    }
}

