/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.processors;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.qubership.integration.platform.engine.camel.CorrelationIdSetter;
import org.qubership.integration.platform.engine.camel.JsonMessageValidator;
import org.qubership.integration.platform.engine.errorhandling.ValidationException;
import org.qubership.integration.platform.engine.service.debugger.util.DebuggerUtils;
import org.qubership.integration.platform.engine.service.debugger.util.MessageHelper;
import org.qubership.integration.platform.engine.service.debugger.util.PayloadExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.MimeType;

@Component
public class HttpTriggerProcessor
implements Processor {
    private static final Logger log = LoggerFactory.getLogger(HttpTriggerProcessor.class);
    private static final Pattern URI_REGEXP = Pattern.compile("(\\/?\\{?[^\\/]*}?\\/?)");
    private static final Pattern VARIABLE_REGEXP = Pattern.compile("^\\/?\\{[^\\/]*}\\/?$");
    private static final String RESPONSE_FILTER_EXCLUDE_QUERY_PARAM = "excludeFields";
    private static final String RESPONSE_FILTER_INCLUDE_QUERY_PARAM = "fields";
    private final CorrelationIdSetter correlationIdSetter;
    private final JsonMessageValidator validator;

    @Autowired
    public HttpTriggerProcessor(CorrelationIdSetter correlationIdSetter, JsonMessageValidator validator) {
        this.correlationIdSetter = correlationIdSetter;
        this.validator = validator;
    }

    public void process(Exchange exchange) throws Exception {
        this.saveUriContextForLogging(exchange);
        this.validate(exchange);
        if (!((Boolean)exchange.getProperty("internalProperty_isCheckpointTriggerStep", (Object)false, Boolean.class)).booleanValue()) {
            this.parsePathVariables(exchange);
        }
        this.parseResponseFilterParameters(exchange);
        this.removeHeaders(exchange);
    }

    private void saveUriContextForLogging(Exchange exchange) {
        String actualUrl = this.getHeader(exchange, "CamelHttpUrl");
        exchange.setProperty("internalProperty_servletRequestUrl", (Object)actualUrl);
        String stepId = DebuggerUtils.getStepChainElementId((String)exchange.getAllProperties().get("CamelStepId").toString());
        exchange.setProperty("httpTriggerStepId", (Object)stepId);
    }

    private void parsePathVariables(Exchange exchange) {
        String uriTemplate = "routes/" + this.getHeader(exchange, "CamelServletContextPath");
        String actualUri = this.getHeader(exchange, "CamelHttpUri");
        Matcher templateMatcher = URI_REGEXP.matcher(uriTemplate);
        Matcher valuesMatcher = URI_REGEXP.matcher(actualUri);
        while (templateMatcher.find()) {
            String value;
            String name = templateMatcher.group();
            if (!StringUtils.isNotBlank((CharSequence)name)) continue;
            Matcher matcher = VARIABLE_REGEXP.matcher(name);
            boolean isParam = matcher.find();
            boolean foundValue = valuesMatcher.find();
            if (!isParam || !foundValue || !StringUtils.isNotBlank((CharSequence)(value = valuesMatcher.group()))) continue;
            String variableName = this.removeServiceSymbols(name);
            String variableValue = this.removeServiceSymbols(value);
            exchange.setProperty(variableName, (Object)variableValue);
        }
        this.correlationIdSetter.setCorrelationId(exchange);
    }

    private String getHeader(Exchange exchange, String headerName) {
        Message message = exchange.getMessage();
        Map headers = message.getHeaders();
        String header = (String)headers.get(headerName);
        return header == null ? "" : header;
    }

    private String removeServiceSymbols(String str) {
        return str.replace("}", "").replace("{", "").replace("/", "");
    }

    private void removeHeaders(Exchange exchange) {
        Message message = exchange.getMessage();
        message.removeHeader("CamelHttpUri");
        message.removeHeader("CamelHttpUrl");
        message.removeHeader("CamelHttpPath");
    }

    private void validate(Exchange exchange) throws IOException {
        this.validateBodyWithGetDelete(exchange);
        this.validateContentType(exchange);
        this.validateJSON(exchange);
    }

    private void validateContentType(Exchange exchange) {
        String[] allowedContentTypes = (String[])exchange.getProperty("internalProperty_allowedContentTypes", String[].class);
        if (allowedContentTypes != null && allowedContentTypes.length > 0) {
            MimeType messageMimeType;
            try {
                messageMimeType = PayloadExtractor.extractContentType((Exchange)exchange);
            }
            catch (Exception e) {
                throw new ValidationException("Unsupported content type: '" + String.valueOf(exchange.getMessage().getHeaders().getOrDefault("Content-Type", "")) + "'");
            }
            for (String allowedType : allowedContentTypes) {
                MimeType allowedMimeType;
                try {
                    allowedMimeType = MimeType.valueOf((String)allowedType);
                }
                catch (Exception e) {
                    throw new RuntimeException("Unsupported content type found in validation list: '" + allowedType + "', please fix it");
                }
                if (messageMimeType == null || !messageMimeType.equalsTypeAndSubtype(allowedMimeType)) continue;
                return;
            }
            throw new ValidationException("Unsupported content type: '" + String.valueOf(messageMimeType) + "'");
        }
    }

    private void validateBodyWithGetDelete(Exchange exchange) throws IOException {
        boolean rejectRequestIfBodyNullGetDelete = (Boolean)exchange.getProperty("internalProperty_rejectRequestIfNonNullBodyGetDelete", (Object)false, Boolean.class);
        if (rejectRequestIfBodyNullGetDelete) {
            String method = (String)exchange.getMessage().getHeader("CamelHttpMethod", String.class);
            if (StringUtils.isNotEmpty((CharSequence)MessageHelper.extractBody((Exchange)exchange)) && ("GET".equalsIgnoreCase(method) || "DELETE".equalsIgnoreCase(method))) {
                throw new ValidationException("Not empty body is not allowed with [" + method + "] method, request rejected");
            }
        }
    }

    private void validateJSON(Exchange exchange) throws IOException {
        String validationSchema = (String)exchange.getProperty("internalProperty_validationSchema", String.class);
        if (!StringUtils.isBlank((CharSequence)validationSchema)) {
            String inputJsonMessage = MessageHelper.extractBody((Exchange)exchange);
            this.validator.validate(inputJsonMessage, validationSchema);
        }
    }

    private void parseResponseFilterParameters(Exchange exchange) {
        Boolean responseFilter = (Boolean)exchange.getProperty("internalProperty_responseFilter", Boolean.class);
        String queryString = (String)exchange.getMessage().getHeader("CamelHttpQuery", String.class);
        if (responseFilter != null && responseFilter.booleanValue() && StringUtils.isNotBlank((CharSequence)queryString)) {
            String includeFilterValue;
            List queryParams = URLEncodedUtils.parse((String)queryString, (Charset)StandardCharsets.UTF_8);
            String excludeFilterValue = queryParams.stream().filter(p -> RESPONSE_FILTER_EXCLUDE_QUERY_PARAM.equals(p.getName())).map(NameValuePair::getValue).findAny().orElse(null);
            if (StringUtils.isNotBlank((CharSequence)excludeFilterValue)) {
                exchange.setProperty("internalProperty_responseFilterExclude", (Object)excludeFilterValue);
            }
            if (StringUtils.isNotBlank((CharSequence)(includeFilterValue = (String)queryParams.stream().filter(p -> RESPONSE_FILTER_INCLUDE_QUERY_PARAM.equals(p.getName())).map(NameValuePair::getValue).findAny().orElse(null)))) {
                exchange.setProperty("internalProperty_responseFilterInclude", (Object)includeFilterValue);
            }
        }
    }
}

