/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.configuration;

import jakarta.annotation.PostConstruct;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class TruststoreConfiguration {
    private static final Logger log = LoggerFactory.getLogger(TruststoreConfiguration.class);
    public final String storeFilePath;
    public final String storePassword;
    public final String certsLocation;
    private static final String JAVA_HOME_PROPERTY = "java.home";
    private static final String JAVA_TRUSTSTORE_PROPERTY = "javax.net.ssl.trustStore";
    private static final String JAVA_TRUSTSTORE_PASSWORD_PROPERTY = "javax.net.ssl.trustStorePassword";
    private static final String JAVA_DEFAULT_TRUSTSTORE_JSSE = "/lib/security/jssecacerts";
    private static final String JAVA_DEFAULT_TRUSTSTORE = "/lib/security/cacerts";
    private static final String JAVA_DEFAULT_TRUSTSTORE_PASSWORD = "changeit";

    @Autowired
    public TruststoreConfiguration(@Value(value="${qip.local-truststore.store.path}") String storeFilePath, @Value(value="${qip.local-truststore.store.password}") String storePassword, @Value(value="${qip.local-truststore.certs.location}") String certsLocation) {
        this.storeFilePath = storeFilePath;
        this.storePassword = storePassword;
        this.certsLocation = certsLocation;
    }

    @PostConstruct
    public void buildTruststore() {
        try {
            KeyStore keyStore = this.getDefaultTrustStore();
            if (Files.exists(Paths.get(this.certsLocation, new String[0]), new LinkOption[0])) {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                try (Stream<Path> pathsStream = Files.walk(Paths.get(this.certsLocation, new String[0]), new FileVisitOption[0]);){
                    List paths = pathsStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> {
                        String str = path.toString();
                        return str.endsWith(".cer") || str.endsWith(".pem") || str.endsWith(".crt") || str.endsWith(".key");
                    }).collect(Collectors.toList());
                    log.info("Found {} trusted certificates (.cer|.pem|.crt|.key)", (Object)paths.size());
                    for (Path certPath : paths) {
                        try {
                            File certFile = new File(certPath.toString());
                            try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(certFile));){
                                Certificate certificate = certificateFactory.generateCertificate(inputStream);
                                keyStore.setCertificateEntry(certFile.getName(), certificate);
                            }
                        }
                        catch (Exception e) {
                            log.error("Failed to load trusted certificate: {}", (Object)certPath.toString(), (Object)e);
                        }
                    }
                }
            } else {
                log.warn("SSL certificates folder {} not exists", (Object)this.certsLocation);
            }
            File storeFile = new File(this.storeFilePath);
            if (storeFile.getParentFile() != null) {
                storeFile.getParentFile().mkdirs();
            }
            try (FileOutputStream fos = new FileOutputStream(storeFile, false);){
                keyStore.store(fos, this.storePassword.toCharArray());
            }
        }
        catch (Exception e) {
            log.error("Failed to load trusted certificates from volume", (Throwable)e);
        }
    }

    private KeyStore getDefaultTrustStore() throws GeneralSecurityException, IOException {
        String[] defaultTrustStores = new String[]{JAVA_DEFAULT_TRUSTSTORE_JSSE, JAVA_DEFAULT_TRUSTSTORE};
        Object trustStorePath = System.getProperty(JAVA_TRUSTSTORE_PROPERTY);
        String trustStorePassword = System.getProperty(JAVA_TRUSTSTORE_PASSWORD_PROPERTY);
        if (StringUtils.isBlank((CharSequence)trustStorePath)) {
            String javaHomePath = System.getProperty(JAVA_HOME_PROPERTY);
            for (String storePath : defaultTrustStores) {
                String fullStorePath = javaHomePath + storePath;
                if (!new File(fullStorePath).isFile()) continue;
                trustStorePath = fullStorePath;
                trustStorePassword = JAVA_DEFAULT_TRUSTSTORE_PASSWORD;
                break;
            }
        }
        if (trustStorePassword == null) {
            trustStorePassword = "";
        }
        File trustStoreFile = StringUtils.isBlank((CharSequence)trustStorePath) ? null : new File((String)trustStorePath);
        try (FileInputStream is = trustStoreFile == null || !trustStoreFile.isFile() ? null : new FileInputStream(trustStoreFile);){
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(is, trustStorePassword.toCharArray());
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
    }
}

