/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.consul;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.integration.platform.engine.consul.KVNotFoundException;
import org.qubership.integration.platform.engine.model.consul.CreateSessionRequest;
import org.qubership.integration.platform.engine.model.consul.CreateSessionResponse;
import org.qubership.integration.platform.engine.model.consul.KeyResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Component
public class ConsulClient {
    private static final Logger log = LoggerFactory.getLogger(ConsulClient.class);
    public static final String CONSUL_TOKEN_HEADER = "X-Consul-Token";
    public static final String CONSUL_INDEX_HEADER = "X-Consul-Index";
    public static final String CONSUL_KV_PATH = "/v1/kv";
    public static final String CREATE_SESSION_PATH = "/v1/session/create";
    public static final String DELETE_SESSION_PATH = "/v1/session/destroy/{sessionId}";
    public static final String RENEW_SESSION_PATH = "/v1/session/renew";
    public static final String CONSUL_KV_QUERY_PARAMS = "?recurse={recurse}&index={index}&wait={wait}";
    private final String consulUrl;
    @Value(value="${consul.token}")
    private String consulToken;
    private final RestTemplate restTemplate;

    @Autowired
    public ConsulClient(@Qualifier(value="consulRestTemplateMS") RestTemplate restTemplate, @Value(value="${consul.url}") String consulUrl) {
        this.restTemplate = restTemplate;
        this.consulUrl = StringUtils.strip((String)consulUrl, (String)"/");
    }

    public void renewSession(String activeSessionId) {
        HttpEntity entity = new HttpEntity((MultiValueMap)this.buildCommonHeaders());
        ResponseEntity response = this.restTemplate.exchange(this.consulUrl + "/v1/session/renew/" + activeSessionId, HttpMethod.PUT, entity, String.class, new Object[0]);
        if (response.getStatusCode() != HttpStatus.OK) {
            log.error("Failed to renew session in consul, code: {}, body: {}", (Object)response.getStatusCode(), response.getBody());
            throw new RuntimeException("Failed to renew session in consul, response with non 2xx code");
        }
    }

    public String createSession(String name, String behavior, String ttl) {
        HttpEntity entity = new HttpEntity((Object)CreateSessionRequest.builder().name(name).behavior(behavior).ttl(ttl).build(), (MultiValueMap)this.buildCommonHeaders());
        ResponseEntity response = this.restTemplate.exchange(this.consulUrl + CREATE_SESSION_PATH, HttpMethod.PUT, entity, CreateSessionResponse.class, new Object[0]);
        if (response.getStatusCode() != HttpStatus.OK) {
            log.error("Failed to create session in consul, code: {}, body: {}", (Object)response.getStatusCode(), response.getBody());
            throw new RuntimeException("Failed to create session in consul, response with non 2xx code");
        }
        return ((CreateSessionResponse)response.getBody()).getId();
    }

    public void deleteSession(String previousSessionId) {
        log.info("Delete old consul session: {}", (Object)previousSessionId);
        ResponseEntity response = this.restTemplate.exchange(this.consulUrl + DELETE_SESSION_PATH, HttpMethod.PUT, new HttpEntity((MultiValueMap)this.buildCommonHeaders()), String.class, Map.of("sessionId", previousSessionId));
        if (response.getStatusCode() != HttpStatus.OK) {
            log.error("Failed to delete session from consul, code: {}, body: {}", (Object)response.getStatusCode(), response.getBody());
            throw new RuntimeException("Failed to delete session from consul, response with non 2xx code");
        }
        if (!"true".equalsIgnoreCase((String)response.getBody())) {
            throw new RuntimeException("Failed delete session from consul, response: " + String.valueOf(response));
        }
    }

    public void createOrUpdateKVWithSession(String key, Object value, String sessionId) {
        this.createOrUpdateKV(key + "?acquire=" + sessionId, value);
    }

    public void createOrUpdateKV(String key, Object value) {
        HttpEntity entity = new HttpEntity(value, (MultiValueMap)this.buildCommonHeaders());
        ResponseEntity response = this.restTemplate.exchange(this.consulUrl + CONSUL_KV_PATH + key, HttpMethod.PUT, entity, String.class, new Object[0]);
        if (response.getStatusCode() != HttpStatus.OK) {
            log.error("Failed to create or update KV in consul, code: {}, body: {}", (Object)response.getStatusCode(), response.getBody());
            throw new RuntimeException("Failed to create or update KV in consul, response with non 2xx code");
        }
        if (!"true".equalsIgnoreCase((String)response.getBody())) {
            throw new RuntimeException("Failed update/create KV in consul, response: " + (String)response.getBody());
        }
    }

    public Pair<Long, List<KeyResponse>> waitForKVChanges(String key, boolean recurse, long index, String waitTimeout) throws KVNotFoundException {
        try {
            HttpEntity entity = new HttpEntity((MultiValueMap)this.buildCommonHeaders());
            ResponseEntity response = this.restTemplate.exchange(this.consulUrl + CONSUL_KV_PATH + key + CONSUL_KV_QUERY_PARAMS, HttpMethod.GET, entity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, Map.of("recurse", recurse, "index", index, "wait", waitTimeout));
            if (response.getStatusCode() != HttpStatus.OK) {
                log.error("Failed to get KV from consul, code: {}, body: {}", (Object)response.getStatusCode(), response.getBody());
                throw new RuntimeException("Failed to get KV from consul, response with non 200 code");
            }
            return Pair.of((Object)Long.parseLong((String)response.getHeaders().get((Object)CONSUL_INDEX_HEADER).get(0)), response.getBody() == null ? Collections.emptyList() : (List)response.getBody());
        }
        catch (HttpClientErrorException hcee) {
            if (hcee.getStatusCode() == HttpStatus.NOT_FOUND) {
                throw new KVNotFoundException("KV not present in consul");
            }
            throw hcee;
        }
    }

    private HttpHeaders buildCommonHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set(CONSUL_TOKEN_HEADER, this.consulToken);
        return headers;
    }
}

