/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.errorhandling;

import jakarta.persistence.EntityNotFoundException;
import java.sql.Timestamp;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.qubership.integration.platform.engine.errorhandling.EngineRuntimeException;
import org.qubership.integration.platform.engine.errorhandling.KubeApiException;
import org.qubership.integration.platform.engine.errorhandling.LoggingMaskingException;
import org.qubership.integration.platform.engine.rest.v1.dto.ExceptionDTO;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

/*
 * Exception performing whole class analysis ignored.
 */
@ControllerAdvice
public class ControllerExceptionHandler
extends ResponseEntityExceptionHandler {
    private static final String NO_STACKTRACE_AVAILABLE_MESSAGE = "No Stacktrace Available";

    @ExceptionHandler
    public ResponseEntity<ExceptionDTO> handleGeneralException(Exception exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)ControllerExceptionHandler.getExceptionDTO((Exception)exception));
    }

    @ExceptionHandler(value={EntityNotFoundException.class})
    public ResponseEntity<ExceptionDTO> handleEntityNotFoundException(EntityNotFoundException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)ControllerExceptionHandler.getExceptionDTO((Exception)exception, (boolean)false));
    }

    @ExceptionHandler(value={KubeApiException.class})
    public final ResponseEntity<ExceptionDTO> handleKubeApiException(EngineRuntimeException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)ControllerExceptionHandler.getExceptionDTO((Exception)exception));
    }

    @ExceptionHandler(value={LoggingMaskingException.class})
    public final ResponseEntity<ExceptionDTO> handleLoggingMaskingException(EngineRuntimeException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)ControllerExceptionHandler.getExceptionDTO((Exception)exception));
    }

    public static ExceptionDTO getExceptionDTO(Exception exception) {
        return ControllerExceptionHandler.getExceptionDTO((Exception)exception, (boolean)true);
    }

    public static ExceptionDTO getExceptionDTO(Exception exception, boolean addStacktrace) {
        String message = exception.getMessage();
        String stacktrace = "No Stacktrace Available";
        if (addStacktrace) {
            if (exception instanceof EngineRuntimeException) {
                EngineRuntimeException systemCatalogRuntimeException = (EngineRuntimeException)exception;
                if (systemCatalogRuntimeException.getOriginalException() != null) {
                    stacktrace = ExceptionUtils.getStackTrace((Throwable)systemCatalogRuntimeException.getOriginalException());
                }
            } else {
                stacktrace = ExceptionUtils.getStackTrace((Throwable)exception);
            }
        }
        return ExceptionDTO.builder().errorMessage(message).stacktrace(stacktrace).errorDate(new Timestamp(System.currentTimeMillis()).toString()).build();
    }
}

