/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.mapper.atlasmap;

import io.atlasmap.core.AtlasPath;
import io.atlasmap.json.v2.AtlasJsonModelFactory;
import io.atlasmap.json.v2.JsonField;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.ConstantField;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.PropertyField;
import io.atlasmap.v2.SimpleField;
import io.atlasmap.xml.v2.AtlasXmlModelFactory;
import io.atlasmap.xml.v2.XmlField;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.qubership.integration.platform.engine.mapper.atlasmap.FieldUtils;
import org.qubership.integration.platform.mapper.ComplexField;
import org.qubership.integration.platform.mapper.GeneratedField;

/*
 * Exception performing whole class analysis ignored.
 */
public class FieldUtils {
    public static boolean hasNotIndexedCollection(AtlasPath path) {
        return path.getSegments(true).stream().anyMatch(s -> Objects.nonNull(s.getCollectionType()) && !CollectionType.NONE.equals((Object)s.getCollectionType()) && Objects.isNull(s.getCollectionIndex()));
    }

    public static List<Field> getCollectionElements(Field field) {
        if (field instanceof FieldGroup) {
            FieldGroup group = (FieldGroup)field;
            return group.getField();
        }
        if (field instanceof ComplexField) {
            ComplexField complexField = (ComplexField)field;
            AtlasPath path = new AtlasPath(field.getPath());
            if (FieldUtils.hasNotIndexedCollection((AtlasPath)path)) {
                return complexField.getChildFields();
            }
            return Collections.singletonList(complexField);
        }
        return Collections.singletonList(field);
    }

    public static String replacePrefixIndex(String s, String from, String to) {
        return Objects.isNull(s) ? null : (s.startsWith(from) ? to + s.substring(from.length() - 1) : s);
    }

    public static void replacePathPrefixIndex(Field field, String from, String to) {
        field.setPath(FieldUtils.replacePrefixIndex((String)field.getPath(), (String)from, (String)to));
        if (field instanceof FieldGroup) {
            FieldGroup group = (FieldGroup)field;
            group.getField().forEach(f -> FieldUtils.replacePathPrefixIndex((Field)f, (String)from, (String)to));
        } else if (field instanceof ComplexField) {
            ComplexField complexField = (ComplexField)field;
            complexField.getChildFields().forEach(f -> FieldUtils.replacePathPrefixIndex((Field)f, (String)from, (String)to));
        }
    }

    public static String replacePrefix(String s, String from, String to) {
        return Objects.isNull(s) ? null : (s.startsWith(from) ? to + s.substring(from.length()) : s);
    }

    public static void replacePathPrefix(Field field, String from, String to) {
        field.setPath(FieldUtils.replacePrefix((String)field.getPath(), (String)from, (String)to));
        if (field instanceof FieldGroup) {
            FieldGroup group = (FieldGroup)field;
            group.getField().forEach(f -> FieldUtils.replacePathPrefix((Field)f, (String)from, (String)to));
        } else if (field instanceof ComplexField) {
            ComplexField complexField = (ComplexField)field;
            complexField.getChildFields().forEach(f -> FieldUtils.replacePathPrefix((Field)f, (String)from, (String)to));
        }
    }

    public static List<Field> getChildren(Field field) {
        List list;
        if (field instanceof ComplexField) {
            ComplexField complexField = (ComplexField)field;
            list = complexField.getChildFields();
        } else if (field instanceof FieldGroup) {
            FieldGroup group = (FieldGroup)field;
            list = group.getField();
        } else {
            list = Collections.emptyList();
        }
        return list;
    }

    public static Field cloneField(Field field) {
        Field field2 = field;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ComplexField.class, FieldGroup.class, SimpleField.class, GeneratedField.class, ConstantField.class, PropertyField.class, JsonField.class, XmlField.class}, (Object)field2, n)) {
            case 0: {
                ComplexField complexField = (ComplexField)field2;
                ComplexField complexFieldCopy = new ComplexField();
                AtlasModelFactory.copyField((Field)complexField, (Field)complexFieldCopy, (boolean)true);
                complexFieldCopy.setValue(complexField.getValue());
                for (Field f : complexField.getChildFields()) {
                    complexFieldCopy.getChildFields().add(FieldUtils.cloneField((Field)f));
                }
                return complexFieldCopy;
            }
            case 1: {
                FieldGroup group = (FieldGroup)field2;
                FieldGroup groupCopy = AtlasModelFactory.copyFieldGroup((FieldGroup)group);
                for (Field f : group.getField()) {
                    groupCopy.getField().add(FieldUtils.cloneField((Field)f));
                }
                return groupCopy;
            }
            case 2: {
                SimpleField simpleField = (SimpleField)field2;
                SimpleField fieldCopy = new SimpleField();
                AtlasModelFactory.copyField((Field)simpleField, (Field)fieldCopy, (boolean)true);
                fieldCopy.setValue(simpleField.getValue());
                return fieldCopy;
            }
            case 3: {
                GeneratedField generatedField = (GeneratedField)field2;
                GeneratedField fieldCopy = new GeneratedField();
                AtlasModelFactory.copyField((Field)generatedField, (Field)fieldCopy, (boolean)true);
                fieldCopy.setValue(generatedField.getValue());
                return fieldCopy;
            }
            case 4: {
                ConstantField constantField = (ConstantField)field2;
                ConstantField fieldCopy = new ConstantField();
                AtlasModelFactory.copyField((Field)constantField, (Field)fieldCopy, (boolean)true);
                fieldCopy.setValue(constantField.getValue());
                return fieldCopy;
            }
            case 5: {
                PropertyField propertyField = (PropertyField)field2;
                PropertyField fieldCopy = new PropertyField();
                AtlasModelFactory.copyField((Field)propertyField, (Field)fieldCopy, (boolean)true);
                fieldCopy.setValue(propertyField.getValue());
                fieldCopy.setScope(propertyField.getScope());
                return fieldCopy;
            }
            case 6: {
                JsonField jsonField = (JsonField)field2;
                JsonField fieldCopy = new JsonField();
                AtlasJsonModelFactory.copyField((Field)jsonField, (Field)fieldCopy, (boolean)true);
                fieldCopy.setValue(jsonField.getValue());
                return fieldCopy;
            }
            case 7: {
                XmlField xmlField = (XmlField)field2;
                XmlField fieldCopy = new XmlField();
                AtlasXmlModelFactory.copyField((Field)xmlField, (Field)fieldCopy, (boolean)true);
                fieldCopy.setValue(xmlField.getValue());
                return fieldCopy;
            }
        }
        return field;
    }

    public static void replacePathSegments(Field field, List<AtlasPath.SegmentContext> from, List<AtlasPath.SegmentContext> to) {
        field.setPath(FieldUtils.replaceSegmentContexts((String)field.getPath(), from, to));
        if (field instanceof FieldGroup) {
            FieldGroup group = (FieldGroup)field;
            group.getField().forEach(f -> FieldUtils.replacePathSegments((Field)f, (List)from, (List)to));
        } else if (field instanceof ComplexField) {
            ComplexField complexField = (ComplexField)field;
            complexField.getChildFields().forEach(f -> FieldUtils.replacePathSegments((Field)f, (List)from, (List)to));
        }
    }

    private static String replaceSegmentContexts(String path, List<AtlasPath.SegmentContext> from, List<AtlasPath.SegmentContext> to) {
        List segments = new AtlasPath(path).getSegments(true);
        return FieldUtils.segmentsStartsWith((List)segments, from) ? FieldUtils.replacePrefixSegments((List)segments, from, to) : path;
    }

    private static boolean segmentsStartsWith(List<AtlasPath.SegmentContext> segments, List<AtlasPath.SegmentContext> prefix) {
        if (segments.size() < prefix.size()) {
            return false;
        }
        for (int i = 0; i < prefix.size(); ++i) {
            AtlasPath.SegmentContext s = segments.get(i);
            AtlasPath.SegmentContext p = prefix.get(i);
            if (s.getName().equals(p.getName()) && s.getCollectionType() == p.getCollectionType()) continue;
            return false;
        }
        return true;
    }

    private static String replacePrefixSegments(List<AtlasPath.SegmentContext> segments, List<AtlasPath.SegmentContext> from, List<AtlasPath.SegmentContext> to) {
        List<AtlasPath.SegmentContext> resultSegments = Stream.concat(to.stream(), segments.subList(from.size(), segments.size()).stream()).toList();
        if (!from.isEmpty() && Objects.nonNull(segments.get(from.size() - 1).getCollectionIndex())) {
            Integer index = segments.get(from.size() - 1).getCollectionIndex();
            Object segmentExpression = ((AtlasPath.SegmentContext)resultSegments.get(to.size() - 1)).getExpression();
            if (((String)segmentExpression).endsWith("<>")) {
                segmentExpression = ((String)segmentExpression).substring(0, ((String)segmentExpression).length() - "<>".length()) + "<" + index.toString() + ">";
            } else if (((String)segmentExpression).endsWith("[]")) {
                segmentExpression = ((String)segmentExpression).substring(0, ((String)segmentExpression).length() - "[]".length()) + "[" + index.toString() + "]";
            }
            resultSegments.set(to.size() - 1, new AtlasPath.SegmentContext((String)segmentExpression));
        }
        return new AtlasPathHelper(resultSegments).toString();
    }
}

