/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.mapper.atlasmap;

import io.atlasmap.api.AtlasException;
import io.atlasmap.core.BaseAtlasModule;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.spi.AtlasModuleDetail;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.ConstantField;
import io.atlasmap.v2.Field;
import java.util.function.Function;
import org.qubership.integration.platform.engine.mapper.atlasmap.ValueGeneratorFactory;
import org.qubership.integration.platform.engine.mapper.atlasmap.ValueGeneratorInfo;
import org.qubership.integration.platform.engine.mapper.atlasmap.ValueGeneratorInfoDecoder;
import org.qubership.integration.platform.mapper.GeneratedField;

@AtlasModuleDetail(name="QipGeneratedValueAtlasModule", uri="atlas:cip:generated", modes={"SOURCE"}, dataFormats={}, configPackages={"org.qubership.integration.platform.engine.mapper.atlasmap"})
public class QipGeneratedValueAtlasModule
extends BaseAtlasModule {
    private static final String VALUE_GENERATOR_PROPERTY_PREFIX = "Atlas.GeneratedValue.";
    private final ValueGeneratorFactory valueGeneratorFactory = new ValueGeneratorFactory();

    public Boolean isSupportedField(Field field) {
        return field instanceof GeneratedField;
    }

    public void processPreValidation(AtlasInternalSession session) throws AtlasException {
    }

    public void processPreSourceExecution(AtlasInternalSession session) throws AtlasException {
        try {
            ValueGeneratorInfo valueGeneratorInfo = ValueGeneratorInfoDecoder.decode((String)this.getUri());
            Function valueGenerator = this.valueGeneratorFactory.getValueGenerator(valueGeneratorInfo.name(), valueGeneratorInfo.parameters());
            String value = (String)valueGenerator.apply(session);
            session.getSourceProperties().put(VALUE_GENERATOR_PROPERTY_PREFIX + this.getDocId(), value);
        }
        catch (Exception exception) {
            throw new AtlasException(exception.getMessage(), (Throwable)exception);
        }
    }

    public void processPreTargetExecution(AtlasInternalSession session) throws AtlasException {
        throw new AtlasException("Module supports only source mode");
    }

    public void readSourceValue(AtlasInternalSession session) throws AtlasException {
        Field field = session.head().getSourceField();
        Field result = this.cloneField(field);
        result.setValue(session.getSourceProperties().get(VALUE_GENERATOR_PROPERTY_PREFIX + this.getDocId()));
        session.head().setSourceField(result);
    }

    public void processPostSourceExecution(AtlasInternalSession session) throws AtlasException {
    }

    public void writeTargetValue(AtlasInternalSession session) throws AtlasException {
        throw new AtlasException("Module supports only source mode");
    }

    public void processPostTargetExecution(AtlasInternalSession session) throws AtlasException {
        throw new AtlasException("Module supports only source mode");
    }

    public Field cloneField(Field field) throws AtlasException {
        Field result = this.createField();
        AtlasModelFactory.copyField((Field)field, (Field)result, (boolean)true);
        result.setValue(field.getValue());
        return result;
    }

    public Field createField() {
        return new ConstantField();
    }
}

