/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.mapper.atlasmap;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ContainerNode;
import io.atlasmap.api.AtlasException;
import io.atlasmap.core.AtlasUtil;
import io.atlasmap.core.BaseAtlasModule;
import io.atlasmap.core.validate.BaseModuleValidationService;
import io.atlasmap.json.core.JsonFieldWriter;
import io.atlasmap.json.inspect.JsonInspectionException;
import io.atlasmap.json.inspect.JsonInspectionService;
import io.atlasmap.json.module.JsonModule;
import io.atlasmap.json.v2.AtlasJsonModelFactory;
import io.atlasmap.json.v2.JsonComplexType;
import io.atlasmap.spi.AtlasFieldReader;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.spi.AtlasModuleDetail;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.Document;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.Fields;
import java.util.function.BiFunction;
import org.qubership.integration.platform.engine.mapper.atlasmap.ComplexMappingAtlasModule;
import org.qubership.integration.platform.engine.mapper.atlasmap.QipJsonAtlasModuleOptions;
import org.qubership.integration.platform.engine.mapper.atlasmap.QipJsonAtlasModuleOptionsDecoder;
import org.qubership.integration.platform.engine.mapper.atlasmap.QipJsonValidationService;
import org.qubership.integration.platform.engine.mapper.atlasmap.json.QipAtlasJsonFieldReader;
import org.qubership.integration.platform.engine.mapper.atlasmap.json.QipJsonInspectionService;
import org.qubership.integration.platform.engine.mapper.atlasmap.json.QipJsonInstanceInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AtlasModuleDetail(name="QipJsonAtlasModule", uri="atlas:cip:json", modes={"SOURCE", "TARGET"}, dataFormats={"json"}, configPackages={"org.qubership.integration.platform.engine.mapper.atlasmap"})
public class QipJsonAtlasModule
extends ComplexMappingAtlasModule {
    private static final Logger LOG = LoggerFactory.getLogger(QipJsonAtlasModule.class);
    private final JsonInspectionService inspectionService = new QipJsonInspectionService(new QipJsonInstanceInspector());

    public QipJsonAtlasModule() {
        super((BaseAtlasModule)new JsonModule());
    }

    protected BaseModuleValidationService<?> getValidationService() {
        return new QipJsonValidationService(this.getClass().getAnnotation(AtlasModuleDetail.class), this.getConversionService(), this.getFieldActionService());
    }

    protected BiFunction<AtlasInternalSession, String, Document> getInspectionService() {
        return (session, source) -> {
            try {
                return this.convertComplexObjectsToFieldGroups((Document)this.inspectionService.inspectJsonDocument(source));
            }
            catch (JsonInspectionException exception) {
                AtlasUtil.addAudit((AtlasInternalSession)session, (String)this.getDocId(), (String)exception.getMessage(), (AuditStatus)AuditStatus.ERROR, (String)"");
                return AtlasJsonModelFactory.createJsonDocument();
            }
        };
    }

    public void processPreTargetExecution(AtlasInternalSession session) throws AtlasException {
        super.processPreTargetExecution(session);
        JsonFieldWriter writer = (JsonFieldWriter)session.getFieldWriter(this.getDocId(), JsonFieldWriter.class);
        ObjectMapper objectMapper = writer.getObjectMapper();
        objectMapper.enable(new JsonGenerator.Feature[]{JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN});
    }

    public void processPreSourceExecution(AtlasInternalSession session) throws AtlasException {
        super.processPreSourceExecution(session);
        Object sourceDocument = session.getSourceDocument(this.getDocId());
        String sourceDocumentString = null;
        if (sourceDocument == null || !(sourceDocument instanceof String)) {
            AtlasUtil.addAudit((AtlasInternalSession)session, (String)this.getDocId(), (String)String.format("Null or non-String source document: docId='%s'", this.getDocId()), (AuditStatus)AuditStatus.WARN, null);
        } else {
            sourceDocumentString = (String)String.class.cast(sourceDocument);
        }
        QipAtlasJsonFieldReader fieldReader = new QipAtlasJsonFieldReader(this.getConversionService());
        fieldReader.setDocument(sourceDocumentString);
        session.setFieldReader(this.getDocId(), (AtlasFieldReader)fieldReader);
    }

    public void processPostTargetExecution(AtlasInternalSession session) throws AtlasException {
        try {
            JsonFieldWriter writer = (JsonFieldWriter)session.getFieldWriter(this.getDocId(), JsonFieldWriter.class);
            if (writer != null && writer.getRootNode() != null) {
                ObjectMapper objectMapper = writer.getObjectMapper();
                QipJsonAtlasModuleOptions options = QipJsonAtlasModuleOptionsDecoder.decode((String)this.getUri());
                ContainerNode documentNode = writer.getRootNode();
                if (options.isSerializeTargetDocument()) {
                    String outputBody = objectMapper.writeValueAsString((Object)documentNode);
                    session.setTargetDocument(this.getDocId(), (Object)outputBody);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(String.format("processPostTargetExecution converting JsonNode to string size=%s", outputBody.length()));
                    }
                } else {
                    session.setTargetDocument(this.getDocId(), (Object)documentNode);
                }
            } else {
                AtlasUtil.addAudit((AtlasInternalSession)session, (String)this.getDocId(), (String)String.format("No target document created for DataSource:[id=%s, uri=%s]", this.getDocId(), this.getUri()), (AuditStatus)AuditStatus.WARN, null);
            }
            session.removeFieldWriter(this.getDocId());
            if (LOG.isDebugEnabled()) {
                LOG.debug("{}: processPostTargetExecution completed", (Object)this.getDocId());
            }
        }
        catch (JsonProcessingException exception) {
            AtlasUtil.addAudit((AtlasInternalSession)session, (String)this.getDocId(), (String)exception.getMessage(), (AuditStatus)AuditStatus.ERROR, null);
        }
    }

    private Document convertComplexObjectsToFieldGroups(Document document) {
        Fields fields = new Fields();
        document.getFields().getField().stream().map(arg_0 -> this.processComplexFields(arg_0)).forEach(fields.getField()::add);
        document.setFields(fields);
        return document;
    }

    private Field processComplexFields(Field field) {
        if (field instanceof JsonComplexType) {
            JsonComplexType complexType = (JsonComplexType)field;
            FieldGroup group = new FieldGroup();
            AtlasModelFactory.copyField((Field)complexType, (Field)group, (boolean)true);
            group.setValue(group.getValue());
            complexType.getJsonFields().getJsonField().stream().map(arg_0 -> this.processComplexFields(arg_0)).forEach(group.getField()::add);
            return group;
        }
        return field;
    }
}

