/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.mapper.atlasmap;

import io.atlasmap.api.AtlasSession;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.function.Function;
import org.qubership.integration.platform.engine.util.AtlasMapUtils;

public class TimestampGenerator
implements Function<AtlasSession, String> {
    private final boolean isUnixEpoch;
    private final String format;
    private final String locale;
    private final String timezone;

    public TimestampGenerator(boolean isUnixEpoch, String format, String locale, String timezone) {
        this.isUnixEpoch = isUnixEpoch;
        this.format = format;
        this.locale = locale;
        this.timezone = timezone;
    }

    public static TimestampGenerator fromParameterList(List<String> parameters) {
        boolean isUnixEpoch = parameters.size() > 0 && Boolean.parseBoolean(parameters.get(0));
        String format = parameters.size() > 1 ? parameters.get(1) : "";
        String locale = parameters.size() > 2 ? parameters.get(2) : "";
        String timezone = parameters.size() > 3 ? parameters.get(3) : "";
        return new TimestampGenerator(isUnixEpoch, format, locale, timezone);
    }

    @Override
    public String apply(AtlasSession atlasSession) {
        String value = (String)atlasSession.getSourceProperties().get("Atlas.CreatedDateTimeTZ");
        return AtlasMapUtils.convertDateFormat((Boolean)false, (String)"yyyy-MM-dd'T'HH:mm:ssZ", (String)Locale.getDefault(Locale.Category.FORMAT).toString(), (String)TimeZone.getDefault().getID(), (Boolean)this.isUnixEpoch, (String)this.format, (String)this.locale, (String)this.timezone, (String)value);
    }
}

