/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.mapper.atlasmap.functions;

import io.atlasmap.core.BaseFunctionFactory;
import io.atlasmap.expression.Expression;
import io.atlasmap.expression.ExpressionContext;
import io.atlasmap.expression.internal.BooleanExpression;
import io.atlasmap.expression.internal.ConstantExpression;
import io.atlasmap.expression.parser.ParseException;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.FieldType;
import java.util.List;
import org.qubership.integration.platform.engine.mapper.atlasmap.FieldUtils;
import org.qubership.integration.platform.engine.mapper.atlasmap.functions.ChainedExpressionContext;
import org.qubership.integration.platform.engine.mapper.atlasmap.functions.MapBasedExpressionContext;

public class FilterFunctionFactory
extends BaseFunctionFactory {
    public String getName() {
        return "filterBy";
    }

    public Expression create(List<Expression> args) throws ParseException {
        if (args.size() != 2) {
            String message = String.format("%s function expects 2 arguments.", this.getName());
            throw new ParseException(message);
        }
        Expression collectionExpression = args.get(0);
        BooleanExpression filterExpression = BooleanExpression.asBooleanExpression((Expression)args.get(1));
        return context -> {
            Field field = collectionExpression.evaluate(context);
            List collection = FieldUtils.getCollectionElements((Field)field);
            FieldGroup filtered = AtlasModelFactory.createFieldGroupFrom((Field)field, (boolean)true);
            filtered.setFieldType(FieldType.ANY);
            for (Field f : collection) {
                ChainedExpressionContext subContext = new ChainedExpressionContext((ExpressionContext)MapBasedExpressionContext.fromField((Field)f, path -> FieldUtils.replacePrefix((String)path, (String)f.getPath(), (String)field.getPath())), context);
                if (filterExpression != ConstantExpression.TRUE && !filterExpression.matches((ExpressionContext)subContext)) continue;
                FieldUtils.replacePathPrefix((Field)f, (String)f.getPath(), (String)field.getPath());
                filtered.getField().add(f);
            }
            return filtered;
        };
    }
}

