/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.mapper.atlasmap.functions;

import io.atlasmap.core.AtlasPath;
import io.atlasmap.core.BaseFunctionFactory;
import io.atlasmap.expression.Expression;
import io.atlasmap.expression.ExpressionContext;
import io.atlasmap.expression.ExpressionException;
import io.atlasmap.expression.parser.ParseException;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.FieldType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.qubership.integration.platform.engine.mapper.atlasmap.FieldUtils;
import org.qubership.integration.platform.engine.mapper.atlasmap.functions.ChainedExpressionContext;
import org.qubership.integration.platform.engine.mapper.atlasmap.functions.MapBasedExpressionContext;
import org.qubership.integration.platform.engine.mapper.atlasmap.functions.SortFunctionFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SortFunctionFactory
extends BaseFunctionFactory {
    public String getName() {
        return "sort";
    }

    public Expression create(List<Expression> args) throws ParseException {
        if (args.size() != 2) {
            String message = String.format("%s function expects 2 arguments.", this.getName());
            throw new ParseException(message);
        }
        Expression collectionExpression = args.get(0);
        Expression sortingKeyExpression = args.get(1);
        return context -> {
            Field field = collectionExpression.evaluate(context);
            List collection = FieldUtils.getCollectionElements((Field)field);
            FieldGroup sorted = AtlasModelFactory.createFieldGroupFrom((Field)field, (boolean)true);
            sorted.setFieldType(FieldType.ANY);
            Function<Field, Field> sortingKeyGetter = f -> {
                ChainedExpressionContext subContext = new ChainedExpressionContext((ExpressionContext)MapBasedExpressionContext.fromField((Field)f, path -> FieldUtils.replacePrefix((String)path, (String)f.getPath(), (String)field.getPath())), context);
                try {
                    return sortingKeyExpression.evaluate((ExpressionContext)subContext);
                }
                catch (ExpressionException exception) {
                    return null;
                }
            };
            Comparator comparator = SortFunctionFactory.getFieldComparator(sortingKeyGetter);
            collection.stream().sorted(comparator).forEachOrdered(f -> {
                FieldUtils.replacePathPrefix((Field)f, (String)f.getPath(), (String)field.getPath());
                sorted.getField().add(f);
            });
            return sorted;
        };
    }

    private static Comparator<Field> getFieldComparator(Function<Field, Field> sortingKeyGetter) {
        Comparator scalarFieldComparator = SortFunctionFactory.getScalarFieldComparator();
        Comparator collectionFieldComparator = SortFunctionFactory.getFieldCollectionComparator((Comparator)scalarFieldComparator);
        return Comparator.comparing(sortingKeyGetter, Comparator.comparing(Objects::isNull).thenComparing(SortFunctionFactory::getFieldType).thenComparing(field -> FieldUtils.hasNotIndexedCollection((AtlasPath)new AtlasPath(field.getPath()))).thenComparing((field1, field2) -> {
            Comparator comparator = FieldUtils.hasNotIndexedCollection((AtlasPath)new AtlasPath(field1.getPath())) ? collectionFieldComparator : scalarFieldComparator;
            return comparator.compare(field1, field2);
        }));
    }

    private static Comparator<Field> getFieldCollectionComparator(Comparator<Field> elementComparator) {
        return Comparator.comparing(FieldUtils::getCollectionElements, Comparator.comparing(Collection::size).thenComparing((l1, l2) -> {
            int l = l1.size();
            for (int i = 0; i < l; ++i) {
                int res = elementComparator.compare((Field)l1.get(i), (Field)l2.get(i));
                if (res == 0) continue;
                return res;
            }
            return 0;
        }));
    }

    private static Comparator<Field> getScalarFieldComparator() {
        return (field1, field2) -> {
            FieldType fieldType = SortFunctionFactory.getFieldType((Field)field1);
            Comparator<Object> valueComparator = switch (1.$SwitchMap$io$atlasmap$v2$FieldType[fieldType.ordinal()]) {
                case 1 -> Comparator.comparing(String::valueOf);
                case 2 -> Comparator.comparing(value -> Character.toString(((Character)value).charValue()));
                case 3 -> Comparator.comparing(value -> (boolean)((Boolean)value));
                case 4 -> Comparator.comparing(value -> (Integer)value);
                case 5, 6, 7 -> Comparator.comparing(value -> new BigDecimal(String.valueOf(value)));
                case 8 -> Comparator.comparing(value -> Short.valueOf(String.valueOf(value)));
                case 9 -> Comparator.comparing(value -> Long.valueOf(String.valueOf(value)));
                case 10 -> Comparator.comparing(value -> Byte.valueOf(String.valueOf(value)));
                case 11 -> Comparator.comparing(value -> new BigInteger(String.valueOf(value)));
                default -> Comparator.comparing(String::valueOf);
            };
            return Comparator.comparing(Field::getValue, Comparator.comparing(Objects::nonNull).thenComparing(valueComparator)).compare((Field)field1, (Field)field2);
        };
    }

    private static FieldType getFieldType(Field field) {
        Optional<Field> optionalField = Optional.ofNullable(field);
        return optionalField.map(Field::getFieldType).or(() -> optionalField.map(Field::getValue).map(SortFunctionFactory::getFieldTypeFromValue)).orElse(FieldType.NONE);
    }

    private static FieldType getFieldTypeFromValue(Object value) {
        if (value instanceof String) {
            return FieldType.STRING;
        }
        if (value instanceof Character) {
            return FieldType.CHAR;
        }
        if (value instanceof Boolean) {
            return FieldType.BOOLEAN;
        }
        if (value instanceof Integer) {
            return FieldType.INTEGER;
        }
        if (value instanceof Double || value instanceof Float) {
            return FieldType.NUMBER;
        }
        if (value instanceof Short) {
            return FieldType.SHORT;
        }
        if (value instanceof Long) {
            return FieldType.LONG;
        }
        if (value instanceof Byte) {
            return FieldType.BYTE;
        }
        if (value instanceof BigInteger) {
            return FieldType.BIG_INTEGER;
        }
        return FieldType.NONE;
    }
}

