/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.opensearch.ism.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hc.core5.http.ContentType;
import org.opensearch.client.opensearch.generic.Body;
import org.opensearch.client.opensearch.generic.Request;
import org.opensearch.client.opensearch.generic.Response;
import org.qubership.integration.platform.engine.opensearch.ism.model.Policy;
import org.qubership.integration.platform.engine.opensearch.ism.model.rest.GenericRequest;
import org.qubership.integration.platform.engine.opensearch.ism.rest.AddPolicyRequest;
import org.qubership.integration.platform.engine.opensearch.ism.rest.PolicyRequest;
import org.qubership.integration.platform.engine.opensearch.ism.rest.RequestHelper;

/*
 * Exception performing whole class analysis ignored.
 */
public class RequestHelper {
    private static final String ISM_ENDPOINT_BASE = "_plugins/_ism";

    public static Request buildGetPolicyRequest(String policyId) {
        String endpoint = RequestHelper.buildPolicyEndpoint((String)policyId);
        return new GenericRequest("GET", endpoint, Collections.emptyList());
    }

    public static Request buildCreatePolicyRequest(ObjectMapper objectMapper, Policy policy) throws JsonProcessingException {
        String endpoint = RequestHelper.buildPolicyEndpoint((String)policy.getPolicyId());
        PolicyRequest policyRequest = PolicyRequest.builder().policy(policy).build();
        String requestText = objectMapper.writeValueAsString((Object)policyRequest);
        return new GenericRequest("PUT", endpoint, Collections.emptyList(), Collections.emptyMap(), Body.from((byte[])requestText.getBytes(), (String)String.valueOf(ContentType.APPLICATION_JSON)));
    }

    public static Request buildUpdatePolicyRequest(ObjectMapper objectMapper, Policy policy, long seqNo, long primaryTerm) throws JsonProcessingException {
        String endpoint = RequestHelper.buildPolicyEndpoint((String)policy.getPolicyId());
        PolicyRequest policyRequest = PolicyRequest.builder().policy(policy).build();
        String requestText = objectMapper.writeValueAsString((Object)policyRequest);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("if_seq_no", Long.toString(seqNo));
        parameters.put("if_primary_term", Long.toString(primaryTerm));
        return new GenericRequest("PUT", endpoint, Collections.emptyList(), parameters, Body.from((byte[])requestText.getBytes(), (String)String.valueOf(ContentType.APPLICATION_JSON)));
    }

    public static Request buildAddPolicyRequest(ObjectMapper objectMapper, String indexName, String policyId) throws JsonProcessingException {
        String endpoint = new EndpointBuilder().addPathPartAsIs(new String[]{"_plugins/_ism"}).addPathPartAsIs(new String[]{"add"}).addPathPart(new String[]{indexName}).build();
        String requestText = objectMapper.writeValueAsString((Object)AddPolicyRequest.builder().policyId(policyId).build());
        return new GenericRequest("POST", endpoint, Collections.emptyList(), Collections.emptyMap(), Body.from((byte[])requestText.getBytes(), (String)String.valueOf(ContentType.APPLICATION_JSON)));
    }

    public static Request buildRemovePolicyFromIndexRequest(String indexName) {
        String endpoint = new EndpointBuilder().addPathPartAsIs(new String[]{"_plugins/_ism"}).addPathPartAsIs(new String[]{"remove"}).addPathPart(new String[]{indexName}).build();
        return new GenericRequest("POST", endpoint, Collections.emptyList());
    }

    private static String buildPolicyEndpoint(String policyId) {
        return new EndpointBuilder().addPathPartAsIs(new String[]{"_plugins/_ism"}).addPathPartAsIs(new String[]{"policies"}).addPathPart(new String[]{policyId}).build();
    }

    public static Request buildPutIndexTemplateRequest(ObjectMapper objectMapper, String templateName, Map<String, Object> request) throws JsonProcessingException {
        String endpoint = new EndpointBuilder().addPathPartAsIs(new String[]{"_index_template"}).addPathPart(new String[]{templateName}).build();
        String requestText = objectMapper.writeValueAsString(request);
        return new GenericRequest("PUT", endpoint, Collections.emptyList(), Collections.emptyMap(), Body.from((byte[])requestText.getBytes(), (String)String.valueOf(ContentType.APPLICATION_JSON)));
    }

    public static Request buildCreateIndexRequest(ObjectMapper objectMapper, String indexName, Map<String, Object> request) throws JsonProcessingException {
        String endpoint = new EndpointBuilder().addPathPart(new String[]{indexName}).build();
        String requestText = objectMapper.writeValueAsString(request);
        return new GenericRequest("PUT", endpoint, Collections.emptyList(), Collections.emptyMap(), Body.from((byte[])requestText.getBytes(), (String)String.valueOf(ContentType.APPLICATION_JSON)));
    }

    public static Request buildPutIndexMapping(ObjectMapper objectMapper, String indexName, Map<String, Object> request) throws JsonProcessingException {
        String endpoint = new EndpointBuilder().addPathPart(new String[]{indexName}).addPathPartAsIs(new String[]{"_mapping"}).build();
        String requestText = objectMapper.writeValueAsString(request);
        return new GenericRequest("PUT", endpoint, Collections.emptyList(), Collections.emptyMap(), Body.from((byte[])requestText.getBytes(), (String)String.valueOf(ContentType.APPLICATION_JSON)));
    }

    public static boolean isHttpError(int status) {
        return Response.Status.Family.familyOf((int)status) == Response.Status.Family.CLIENT_ERROR;
    }

    public static void processHttpResponse(Response response) throws IOException {
        if (RequestHelper.isHttpError((int)response.getStatus())) {
            throw new IOException("Opensearch request error: " + (response.getBody().isPresent() ? ((Body)response.getBody().get()).bodyAsString() : ""));
        }
    }
}

