/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.scheduler;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.integration.platform.engine.consul.ConsulService;
import org.qubership.integration.platform.engine.consul.DeploymentReadinessService;
import org.qubership.integration.platform.engine.consul.KVNotFoundException;
import org.qubership.integration.platform.engine.service.CheckpointSessionService;
import org.qubership.integration.platform.engine.service.DeploymentsUpdateService;
import org.qubership.integration.platform.engine.service.IntegrationRuntimeService;
import org.qubership.integration.platform.engine.service.VariablesService;
import org.qubership.integration.platform.engine.service.contextstorage.ContextStorageService;
import org.qubership.integration.platform.engine.service.debugger.CamelDebuggerPropertiesService;
import org.qubership.integration.platform.engine.service.externallibrary.ExternalLibraryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class TasksScheduler {
    private static final Logger log = LoggerFactory.getLogger(TasksScheduler.class);
    private final VariablesService variableService;
    private final IntegrationRuntimeService runtimeService;
    private final CheckpointSessionService checkpointSessionService;
    private final DeploymentReadinessService deploymentReadinessService;
    private final ConsulService consulService;
    private final DeploymentsUpdateService deploymentsUpdateService;
    private final Optional<ExternalLibraryService> externalLibraryService;
    private final CamelDebuggerPropertiesService debuggerPropertiesService;
    @Value(value="${qip.sessions.checkpoints.cleanup.interval}")
    private String checkpointsInterval;
    private final ContextStorageService contextStorageService;

    @Autowired
    public TasksScheduler(VariablesService variableService, IntegrationRuntimeService runtimeService, CheckpointSessionService checkpointSessionService, DeploymentReadinessService deploymentReadinessService, ConsulService consulService, DeploymentsUpdateService deploymentsUpdateService, Optional<ExternalLibraryService> externalLibraryService, CamelDebuggerPropertiesService debuggerPropertiesService, ContextStorageService contextStorageService) {
        this.variableService = variableService;
        this.runtimeService = runtimeService;
        this.checkpointSessionService = checkpointSessionService;
        this.deploymentReadinessService = deploymentReadinessService;
        this.consulService = consulService;
        this.deploymentsUpdateService = deploymentsUpdateService;
        this.externalLibraryService = externalLibraryService;
        this.debuggerPropertiesService = debuggerPropertiesService;
        this.contextStorageService = contextStorageService;
    }

    @Scheduled(fixedDelay=2500L)
    public void refreshCommonVariables() {
        try {
            Pair pair = this.consulService.waitForCommonVariables();
            if (((Boolean)pair.getLeft()).booleanValue()) {
                log.debug("Common variables changes detected");
                this.variableService.updateCommonVariables((Map)pair.getRight());
            }
        }
        catch (KVNotFoundException kvnfe) {
            log.debug("Common variables KV is empty. {}", (Object)kvnfe.getMessage());
            this.variableService.updateCommonVariables(Collections.emptyMap());
        }
        catch (Exception e) {
            log.error("Failed to update common variables. {}", (Object)e.getMessage());
            this.consulService.rollbackCommonVariablesLastIndex();
        }
    }

    @Scheduled(fixedDelay=5000L)
    public void refreshSecuredVariables() {
        this.variableService.refreshSecuredVariables();
    }

    @Scheduled(fixedDelayString="${qip.deployments.retry-delay}", initialDelayString="${qip.deployments.retry-delay}")
    public void retryProcessingDeploys() {
        if (this.deploymentReadinessService.isInitialized()) {
            this.runtimeService.retryProcessingDeploys();
        }
    }

    @Scheduled(cron="${qip.sessions.checkpoints.cleanup.cron}")
    public void cleanupCheckpointSessions() {
        this.checkpointSessionService.deleteOldRecordsByInterval(this.checkpointsInterval);
        log.info("Scheduled checkpoints cleanup completed");
    }

    @Scheduled(cron="${qip.context-service.cleanup.cron}")
    public void cleanupContextStorage() {
        this.contextStorageService.deleteOldRecords();
        log.info("Scheduled context record cleanup completed");
    }

    @Scheduled(fixedRate=30000L)
    public void renewConsulSession() {
        this.consulService.createOrRenewSession();
    }

    @Scheduled(fixedDelay=2500L)
    public void checkDeploymentUpdates() {
        block7: {
            if (this.deploymentReadinessService.isReadyForDeploy()) {
                try {
                    boolean firstDeploy;
                    boolean bl = firstDeploy = !this.deploymentReadinessService.isInitialized();
                    if (firstDeploy) {
                        this.deploymentsUpdateService.getAndProcess();
                        this.runtimeService.startAllRoutesOnInit();
                        this.deploymentReadinessService.setInitialized(true);
                        break block7;
                    }
                    try {
                        Pair response = this.consulService.waitForDeploymentsUpdate();
                        if (((Boolean)response.getLeft()).booleanValue()) {
                            this.deploymentsUpdateService.getAndProcess();
                        }
                    }
                    catch (KVNotFoundException kvnfe) {
                        log.debug("Deployments update KV is empty. {}", (Object)kvnfe.getMessage());
                    }
                }
                catch (Exception e) {
                    log.error("Failed to get or process deployments from runtime catalog: {}", (Object)e.getMessage());
                    this.consulService.rollbackDeploymentsStateLastIndex();
                }
            }
        }
    }

    @Scheduled(fixedDelay=2500L)
    public void checkLibrariesUpdates() {
        if (this.externalLibraryService.isPresent()) {
            try {
                Pair response = this.consulService.waitForLibrariesUpdate();
                if (((Boolean)response.getLeft()).booleanValue()) {
                    ((ExternalLibraryService)this.externalLibraryService.get()).updateSystemModelLibraries((List)response.getRight());
                }
            }
            catch (KVNotFoundException kvnfe) {
                log.warn("Libraries update KV is empty. {}", (Object)kvnfe.getMessage());
            }
            catch (Exception e) {
                log.error("Failed to get libraries update from consul/systems-catalog", (Throwable)e);
                this.consulService.rollbackLibrariesLastIndex();
            }
        }
    }

    @Scheduled(fixedDelay=1000L)
    public void checkRuntimeDeploymentProperties() {
        try {
            Pair response = this.consulService.waitForChainRuntimeConfig();
            if (((Boolean)response.getLeft()).booleanValue()) {
                this.debuggerPropertiesService.updateRuntimeProperties((Map)response.getRight());
            }
        }
        catch (KVNotFoundException kvnfe) {
            log.debug("Runtime deployments properties KV is empty. {}", (Object)kvnfe.getMessage());
            this.debuggerPropertiesService.updateRuntimeProperties(Collections.emptyMap());
        }
        catch (Exception e) {
            log.error("Failed to get runtime deployments properties from consul", (Throwable)e);
            this.consulService.rollbackChainsRuntimeConfigLastIndex();
        }
    }
}

