/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service.debugger.metrics;

import io.micrometer.core.instrument.DistributionSummary;
import java.util.Map;
import org.apache.camel.Exchange;
import org.qubership.integration.platform.engine.errorhandling.errorcode.ErrorCode;
import org.qubership.integration.platform.engine.model.ChainElementType;
import org.qubership.integration.platform.engine.model.deployment.engine.EngineDeployment;
import org.qubership.integration.platform.engine.model.deployment.properties.CamelDebuggerProperties;
import org.qubership.integration.platform.engine.model.deployment.update.DeploymentInfo;
import org.qubership.integration.platform.engine.service.debugger.metrics.MetricsService;
import org.qubership.integration.platform.engine.service.debugger.metrics.MetricsStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MetricsService {
    private static final Logger log = LoggerFactory.getLogger(MetricsService.class);
    private final MetricsStore metricsStore;

    @Autowired
    public MetricsService(MetricsStore metricsStore) {
        this.metricsStore = metricsStore;
    }

    public void processElementStartMetrics(Exchange exchange, CamelDebuggerProperties dbgProperties, String stepId, String stepName, ChainElementType elementType) {
        if (!this.metricsStore.isMetricsEnabled()) {
            return;
        }
        try {
            Map stepProperties = dbgProperties.getElementProperty(stepId);
            DeploymentInfo deploymentInfo = dbgProperties.getDeploymentInfo();
            switch (1.$SwitchMap$org$qubership$integration$platform$engine$model$ChainElementType[elementType.ordinal()]) {
                case 1: 
                case 2: {
                    if (!stepId.equals(stepName)) break;
                    this.metricsStore.processCircuitBreakerExecution(dbgProperties.getDeploymentInfo().getChainId(), dbgProperties.getDeploymentInfo().getChainName(), (String)dbgProperties.getElementProperty(stepId).get("elementId"), (String)dbgProperties.getElementProperty(stepId).get("elementName"));
                    break;
                }
                case 3: 
                case 4: {
                    DistributionSummary distributionSummary = this.metricsStore.processHttpPayloadSize(true, deploymentInfo.getChainId(), deploymentInfo.getChainName(), (String)stepProperties.get("elementId"), (String)stepProperties.get("elementName"), (String)stepProperties.get("elementType"));
                    distributionSummary.record((double)this.calculatePayloadSize(exchange));
                    break;
                }
                case 5: {
                    if (!this.metricNeedsToBeRecorded(stepProperties)) break;
                    DistributionSummary distributionSummary = this.metricsStore.processHttpPayloadSize(true, deploymentInfo.getChainId(), deploymentInfo.getChainName(), (String)stepProperties.get("elementId"), (String)stepProperties.get("elementName"), (String)stepProperties.get("elementType"));
                    distributionSummary.record((double)this.calculatePayloadSize(exchange));
                }
            }
        }
        catch (Exception e) {
            log.warn("Failed to create metrics data", (Throwable)e);
        }
    }

    public void processElementFinishMetrics(Exchange exchange, CamelDebuggerProperties dbgProperties, String stepId, String stepName, ChainElementType elementType, boolean failed) {
        if (!this.metricsStore.isMetricsEnabled()) {
            return;
        }
        try {
            Map stepProperties = dbgProperties.getElementProperty(stepId);
            DeploymentInfo deploymentInfo = dbgProperties.getDeploymentInfo();
            switch (1.$SwitchMap$org$qubership$integration$platform$engine$model$ChainElementType[elementType.ordinal()]) {
                case 1: 
                case 2: 
                case 6: 
                case 7: {
                    String elementId = (String)stepProperties.get("elementId");
                    String elementName = (String)stepProperties.get("elementName");
                    if (elementType == ChainElementType.CIRCUIT_BREAKER_MAIN_ELEMENT || elementType == ChainElementType.CIRCUIT_BREAKER_MAIN_ELEMENT_2) {
                        elementId = (String)stepProperties.get("parentElementOriginalId");
                        elementName = (String)stepProperties.get("parentElementName");
                    }
                    boolean hasFallback = Boolean.parseBoolean(String.valueOf(exchange.getProperty("internalProperty_circuitBreaker_hasFallback")));
                    if (!failed || hasFallback || !"Main branch".equals(stepName)) break;
                    this.metricsStore.processCircuitBreakerExecutionFallback(deploymentInfo.getChainId(), deploymentInfo.getChainName(), elementId, elementName);
                    break;
                }
                case 8: 
                case 9: {
                    this.metricsStore.processCircuitBreakerExecutionFallback(deploymentInfo.getChainId(), deploymentInfo.getChainName(), (String)stepProperties.get("parentElementOriginalId"), (String)stepProperties.get("parentElementName"));
                    break;
                }
                case 4: {
                    DistributionSummary distributionSummary = this.metricsStore.processHttpPayloadSize(false, deploymentInfo.getChainId(), deploymentInfo.getChainName(), (String)stepProperties.get("elementId"), (String)stepProperties.get("elementName"), (String)stepProperties.get("elementType"));
                    distributionSummary.record((double)this.calculatePayloadSize(exchange));
                    break;
                }
                case 5: {
                    if (!this.metricNeedsToBeRecorded(stepProperties)) break;
                    DistributionSummary distributionSummary = this.metricsStore.processHttpPayloadSize(false, deploymentInfo.getChainId(), deploymentInfo.getChainName(), (String)stepProperties.get("elementId"), (String)stepProperties.get("elementName"), (String)stepProperties.get("elementType"));
                    distributionSummary.record((double)this.calculatePayloadSize(exchange));
                    break;
                }
            }
        }
        catch (Exception e) {
            log.warn("Failed to create metrics data", (Throwable)e);
        }
    }

    private boolean metricNeedsToBeRecorded(Map<String, String> stepProperties) {
        return "http".equals(stepProperties.get("integrationOperationProtocolType"));
    }

    private int calculatePayloadSize(Exchange exchange) {
        Object length = exchange.getMessage().getHeader("Content-Length");
        if (length == null) {
            return 0;
        }
        try {
            if (length instanceof Integer) {
                return (Integer)length;
            }
            return Integer.parseInt(length.toString());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public void processHttpResponseCode(CamelDebuggerProperties dbgProperties, String responseCode) {
        this.metricsStore.processHttpResponseCode(dbgProperties.getDeploymentInfo().getChainId(), dbgProperties.getDeploymentInfo().getChainName(), responseCode);
    }

    public void processHttpTriggerPayloadSize(Exchange exchange, CamelDebuggerProperties dbgProperties) {
        if (this.metricsStore.isMetricsEnabled()) {
            DeploymentInfo deploymentInfo = dbgProperties.getDeploymentInfo();
            Map elementProperties = dbgProperties.getElementProperty(exchange.getProperty("httpTriggerStepId").toString());
            String elementId = (String)elementProperties.get("elementId");
            String elementType = (String)elementProperties.get("elementType");
            String elementName = (String)elementProperties.get("elementName");
            DistributionSummary distributionSummary = this.metricsStore.processHttpPayloadSize(false, deploymentInfo.getChainId(), deploymentInfo.getChainName(), elementId, elementName, elementType);
            distributionSummary.record((double)this.calculatePayloadSize(exchange));
        }
    }

    public void processSessionFinish(CamelDebuggerProperties dbgProperties, String executionStatus, long duration) {
        this.metricsStore.processSessionFinish(dbgProperties.getDeploymentInfo().getChainId(), dbgProperties.getDeploymentInfo().getChainName(), executionStatus, duration);
    }

    public void processChainFailure(DeploymentInfo deploymentInfo, ErrorCode errorCode) {
        this.metricsStore.processChainFailure(deploymentInfo.getChainId(), deploymentInfo.getChainName(), errorCode);
    }

    public void processChainsDeployments(EngineDeployment deployment) {
        DeploymentInfo deploymentInfo = deployment.getDeploymentInfo();
        String statusCode = deploymentInfo.getChainStatusCode();
        if (statusCode == null) {
            statusCode = "";
        }
        this.metricsStore.processChainsDeployments(deploymentInfo.getDeploymentId(), deploymentInfo.getChainId(), deploymentInfo.getChainName(), deployment.getStatus().name(), statusCode, deploymentInfo.getSnapshotName());
    }
}

