/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service.debugger.metrics;

import com.google.common.collect.Maps;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.qubership.integration.platform.engine.configuration.ServerConfiguration;
import org.qubership.integration.platform.engine.errorhandling.errorcode.ErrorCode;
import org.qubership.integration.platform.engine.model.ChainElementType;
import org.qubership.integration.platform.engine.persistence.shared.entity.ChainDataAllocationSize;
import org.qubership.integration.platform.engine.service.debugger.metrics.MetricsStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class MetricsStore {
    private static final Logger log = LoggerFactory.getLogger(MetricsStore.class);
    private static final String SESSION_TIMER_NAME = "sessions.duration.timer";
    private static final String SESSIONS_COUNTER_NAME = "sessions.counter";
    private static final String CHAINS_FAILURES_COUNTER_NAME = "chains.failures";
    private static final String SYSTEM_RESPONSE_CODE_NAME = "system.response.code";
    private static final String CIRCUIT_BREAKER_EXECUTION_NAME = "elements.circuitbreaker.execution";
    private static final String CIRCUIT_BREAKER_EXECUTION_FALLBACK_NAME = "elements.circuitbreaker.execution.fallback";
    private static final String HTTP_TRIGGER_REQUEST_PAYLOAD_SIZE_NAME = "http.trigger.request.payload.size";
    private static final String HTTP_TRIGGER_RESPONSE_PAYLOAD_SIZE_NAME = "http.trigger.response.payload.size";
    private static final String HTTP_SENDERS_REQUEST_PAYLOAD_SIZE_NAME = "http.senders.request.payload.size";
    private static final String HTTP_SENDERS_RESPONSE_PAYLOAD_SIZE_NAME = "http.senders.response.payload.size";
    private static final String CHAINS_DEPLOYMENTS_NAME = "chains.deployments";
    private static final String CHAIN_SESSION_SIZE = "chain.session.size";
    private static final String CHAIN_CHECKPOINT_SIZE = "chain.checkpoint.size";
    private static final String EXECUTION_STATUS_TAG = "execution_status";
    private static final String CHAIN_STATUS_CODE_TAG = "chain_status_code";
    private static final String CHAIN_STATUS_REASON_TAG = "chain_status_reason";
    private static final String SNAPSHOT_NAME_TAG = "snapshot_name";
    public static final String CHAIN_ID_TAG = "chain_id";
    public static final String CHAIN_NAME_TAG = "chain_name";
    public static final String ELEMENT_ID_TAG = "element_id";
    public static final String ELEMENT_NAME_TAG = "element_name";
    public static final String ELEMENT_TYPE_TAG = "element_type";
    public static final String ENGINE_DOMAIN_TAG = "engine_domain";
    private static final String RESPONSE_CODE_TAG = "response_code";
    public static final String MAAS_CLASSIFIER = "maas_classifier";
    private final String namePrefix;
    private static final int CHAINS_DEPLOYMENTS_NUMBER = 1;
    @Value(value="${qip.metrics.prometheus.init.delay}")
    private long lagDelay;
    @Value(value="${qip.metrics.enabled}")
    private boolean metricsEnabled;
    @Value(value="${qip.metrics.http-payload-metrics.enabled}")
    private boolean httpPayloadMetricsEnabled;
    @Value(value="${qip.metrics.http-payload-metrics.buckets}")
    private double[] httpPayloadMetricsBuckets;
    private final MeterRegistry meterRegistry;
    private final ConcurrentMap<String, ConcurrentMap<String, CounterWrapper>> responseCodeCounters;
    private final ConcurrentMap<String, ConcurrentMap<String, Timer>> sessionExecutionTime;
    private final ConcurrentMap<String, ConcurrentMap<String, CounterWrapper>> sessionsCounters;
    private final ConcurrentMap<String, ConcurrentMap<String, CounterWrapper>> circuitBreakerExecutionCounters;
    private final ConcurrentMap<String, ConcurrentMap<String, CounterWrapper>> circuitBreakerExecutionFallbackCounters;
    private final ConcurrentMap<String, ConcurrentMap<ErrorCode, CounterWrapper>> chainsFailuresCounters;
    private final ConcurrentMap<String, ConcurrentMap<String, Gauge>> chainsDeploymentsGauges;
    private final ConcurrentMap<String, ConcurrentMap<String, DistributionSummary>> httpPayloadSizeDistributionSummary;
    private final ConcurrentMap<String, AtomicLong> sessionSizeGauges;
    private final ConcurrentMap<String, AtomicLong> checkpointsSizeGauges;
    private final ServerConfiguration serverConfiguration;

    @Autowired
    public MetricsStore(ServerConfiguration serverConfiguration, MeterRegistry meterRegistry, @Value(value="${app.prefix}") String appPrefix) {
        this.serverConfiguration = serverConfiguration;
        this.meterRegistry = meterRegistry;
        this.sessionExecutionTime = Maps.newConcurrentMap();
        this.sessionsCounters = Maps.newConcurrentMap();
        this.responseCodeCounters = Maps.newConcurrentMap();
        this.circuitBreakerExecutionCounters = Maps.newConcurrentMap();
        this.circuitBreakerExecutionFallbackCounters = Maps.newConcurrentMap();
        this.chainsFailuresCounters = Maps.newConcurrentMap();
        this.chainsDeploymentsGauges = Maps.newConcurrentMap();
        this.httpPayloadSizeDistributionSummary = Maps.newConcurrentMap();
        this.sessionSizeGauges = Maps.newConcurrentMap();
        this.checkpointsSizeGauges = Maps.newConcurrentMap();
        this.namePrefix = appPrefix + ".engine.";
    }

    public void processSessionFinish(String chainId, String chainName, String status, long duration) {
        if (this.metricsEnabled) {
            ConcurrentMap timerMap = this.sessionExecutionTime.computeIfAbsent(this.buildChainMapKey(chainId, chainName), id -> Maps.newConcurrentMap());
            Timer timer = timerMap.computeIfAbsent(status, executionStatus -> this.newSessionDurationTimer(chainId, chainName, executionStatus));
            timer.record(duration, TimeUnit.MILLISECONDS);
            ConcurrentMap counterMap = this.sessionsCounters.computeIfAbsent(this.buildChainMapKey(chainId, chainName), id -> Maps.newConcurrentMap());
            CounterWrapper sessionsCounter = counterMap.computeIfAbsent(status, executionStatus -> {
                CounterWrapper counterWrapper = new CounterWrapper(this.newCounter(chainId, chainName, executionStatus));
                Executors.newSingleThreadScheduledExecutor().schedule(() -> ((CounterWrapper)counterWrapper).commitAndUnlock(), this.lagDelay, TimeUnit.SECONDS);
                return counterWrapper;
            });
            sessionsCounter.increment();
        }
    }

    public void processChainFailure(String chainId, String chainName, ErrorCode errorCode) {
        if (this.metricsEnabled) {
            ConcurrentMap chainFailuresCounterMap = this.chainsFailuresCounters.computeIfAbsent(this.buildChainMapKey(chainId, chainName), id -> Maps.newConcurrentMap());
            CounterWrapper chainFailureCounter = chainFailuresCounterMap.computeIfAbsent(errorCode, currentErrorCode -> {
                CounterWrapper counterWrapper = new CounterWrapper(this.newChainsFailuresCounter(chainId, chainName, currentErrorCode));
                Executors.newSingleThreadScheduledExecutor().schedule(() -> ((CounterWrapper)counterWrapper).commitAndUnlock(), this.lagDelay, TimeUnit.SECONDS);
                return counterWrapper;
            });
            chainFailureCounter.increment();
        }
    }

    public void processHttpResponseCode(String chainId, String chainName, String responseCode) {
        if (this.metricsEnabled) {
            ConcurrentMap chainResponseCodeMap = this.responseCodeCounters.computeIfAbsent(this.buildChainMapKey(chainId, chainName), id -> Maps.newConcurrentMap());
            CounterWrapper responseCounter = chainResponseCodeMap.computeIfAbsent(responseCode, executionStatus -> {
                CounterWrapper counterWrapper = new CounterWrapper(this.newResponseCodeCounter(chainId, chainName, responseCode));
                Executors.newSingleThreadScheduledExecutor().schedule(() -> ((CounterWrapper)counterWrapper).commitAndUnlock(), this.lagDelay, TimeUnit.SECONDS);
                return counterWrapper;
            });
            responseCounter.increment();
        }
    }

    public void processCircuitBreakerExecution(String chainId, String chainName, String elementId, String elementName) {
        if (this.metricsEnabled) {
            ConcurrentMap cbExecutionMap = this.circuitBreakerExecutionCounters.computeIfAbsent(this.buildChainMapKey(chainId, chainName), id -> Maps.newConcurrentMap());
            CounterWrapper responseCounter = cbExecutionMap.computeIfAbsent(elementId, executionStatus -> {
                CounterWrapper counterWrapper = new CounterWrapper(this.newCircuitBreakerExecutionCounter(chainId, chainName, elementId, elementName));
                Executors.newSingleThreadScheduledExecutor().schedule(() -> ((CounterWrapper)counterWrapper).commitAndUnlock(), this.lagDelay, TimeUnit.SECONDS);
                return counterWrapper;
            });
            responseCounter.increment();
        }
    }

    public void processCircuitBreakerExecutionFallback(String chainId, String chainName, String elementId, String elementName) {
        if (this.metricsEnabled) {
            ConcurrentMap cbExecutionFallbackMap = this.circuitBreakerExecutionFallbackCounters.computeIfAbsent(this.buildChainMapKey(chainId, chainName), id -> Maps.newConcurrentMap());
            CounterWrapper responseCounter = cbExecutionFallbackMap.computeIfAbsent(elementId, executionStatus -> {
                CounterWrapper counterWrapper = new CounterWrapper(this.newCircuitBreakerExecutionFallbackCounter(chainId, chainName, elementId, elementName));
                Executors.newSingleThreadScheduledExecutor().schedule(() -> ((CounterWrapper)counterWrapper).commitAndUnlock(), this.lagDelay, TimeUnit.SECONDS);
                return counterWrapper;
            });
            responseCounter.increment();
        }
    }

    public void processChainsDeployments(String deploymentId, String chainId, String chainName, String executionStatus, String chainStatusCode, String snapshotName) {
        if (this.metricsEnabled) {
            ConcurrentMap chainsInfoMap = this.chainsDeploymentsGauges.computeIfAbsent(deploymentId, id -> Maps.newConcurrentMap());
            chainsInfoMap.computeIfAbsent(deploymentId, computedExecutionStatus -> this.newChainsDeploymentsGauge(chainId, chainName, executionStatus, chainStatusCode, snapshotName));
        }
    }

    public DistributionSummary processHttpPayloadSize(boolean isRequest, String chainId, String chainName, String elementId, String elementName, String elementType) {
        if (this.metricsEnabled && this.httpPayloadMetricsEnabled) {
            ConcurrentMap httpPayloadSizeMap = this.httpPayloadSizeDistributionSummary.computeIfAbsent(this.buildChainMapKey(chainId, chainName), id -> Maps.newConcurrentMap());
            String payloadType = isRequest ? "_request" : "_response";
            return httpPayloadSizeMap.computeIfAbsent(elementId + payloadType, computedDistributionSummary -> this.newHttpPayloadSizeDistributionSummary(isRequest, chainId, chainName, elementId, elementName, elementType));
        }
        return null;
    }

    public void processChainSessionsSize(List<ChainDataAllocationSize> chainSessionsSizes) {
        if (this.metricsEnabled) {
            this.processChainDataAllocationSize(this.namePrefix + CHAIN_SESSION_SIZE, this.sessionSizeGauges, chainSessionsSizes);
        }
    }

    public void processChainCheckpointsSize(List<ChainDataAllocationSize> chainCheckpointSizes) {
        if (this.metricsEnabled) {
            this.processChainDataAllocationSize(this.namePrefix + CHAIN_CHECKPOINT_SIZE, this.checkpointsSizeGauges, chainCheckpointSizes);
        }
    }

    public void removeChainsDeployments(String deploymentId) {
        if (this.metricsEnabled) {
            for (Map.Entry chainsDeploymentGauge : this.chainsDeploymentsGauges.entrySet()) {
                if (!deploymentId.equals(chainsDeploymentGauge.getKey())) continue;
                for (Map.Entry gauge : ((ConcurrentMap)chainsDeploymentGauge.getValue()).entrySet()) {
                    if (!deploymentId.equals(gauge.getKey())) continue;
                    this.meterRegistry.remove((Meter)gauge.getValue());
                }
            }
        }
    }

    private Timer newSessionDurationTimer(String chainId, String chainName, String executionStatus) {
        return Timer.builder((String)(this.namePrefix + SESSION_TIMER_NAME)).publishPercentileHistogram().tag(CHAIN_ID_TAG, chainId).tag(CHAIN_NAME_TAG, chainName).tag(EXECUTION_STATUS_TAG, executionStatus).tag(ENGINE_DOMAIN_TAG, this.serverConfiguration.getDomain()).register(this.meterRegistry);
    }

    private Counter newCounter(String chainId, String chainName, String executionStatus) {
        return Counter.builder((String)(this.namePrefix + SESSIONS_COUNTER_NAME)).tag(CHAIN_ID_TAG, chainId).tag(CHAIN_NAME_TAG, chainName).tag(EXECUTION_STATUS_TAG, executionStatus).tag(ENGINE_DOMAIN_TAG, this.serverConfiguration.getDomain()).register(this.meterRegistry);
    }

    private Counter newResponseCodeCounter(String chainId, String chainName, String responseCode) {
        return Counter.builder((String)(this.namePrefix + SYSTEM_RESPONSE_CODE_NAME)).tag(CHAIN_ID_TAG, chainId).tag(CHAIN_NAME_TAG, chainName).tag(RESPONSE_CODE_TAG, responseCode).tag(ENGINE_DOMAIN_TAG, this.serverConfiguration.getDomain()).register(this.meterRegistry);
    }

    private Counter newCircuitBreakerExecutionCounter(String chainId, String chainName, String elementId, String elementName) {
        return Counter.builder((String)(this.namePrefix + CIRCUIT_BREAKER_EXECUTION_NAME)).tag(CHAIN_ID_TAG, chainId).tag(CHAIN_NAME_TAG, chainName).tag(ELEMENT_ID_TAG, elementId).tag(ELEMENT_NAME_TAG, elementName).tag(ENGINE_DOMAIN_TAG, this.serverConfiguration.getDomain()).register(this.meterRegistry);
    }

    private Counter newCircuitBreakerExecutionFallbackCounter(String chainId, String chainName, String elementId, String elementName) {
        return Counter.builder((String)(this.namePrefix + CIRCUIT_BREAKER_EXECUTION_FALLBACK_NAME)).tag(CHAIN_ID_TAG, chainId).tag(CHAIN_NAME_TAG, chainName).tag(ELEMENT_ID_TAG, elementId).tag(ELEMENT_NAME_TAG, elementName).tag(ENGINE_DOMAIN_TAG, this.serverConfiguration.getDomain()).register(this.meterRegistry);
    }

    private Counter newChainsFailuresCounter(String chainId, String chainName, ErrorCode errorCode) {
        return Counter.builder((String)(this.namePrefix + CHAINS_FAILURES_COUNTER_NAME)).tag(CHAIN_ID_TAG, chainId).tag(CHAIN_NAME_TAG, chainName).tag(CHAIN_STATUS_CODE_TAG, errorCode.getCode()).tag(CHAIN_STATUS_REASON_TAG, errorCode.getPayload().getReason()).tag(ENGINE_DOMAIN_TAG, this.serverConfiguration.getDomain()).register(this.meterRegistry);
    }

    private Gauge newChainsDeploymentsGauge(String chainId, String chainName, String executionStatus, String chainStatusCode, String snapshotName) {
        return Gauge.builder((String)(this.namePrefix + CHAINS_DEPLOYMENTS_NAME), () -> 1).tag(CHAIN_ID_TAG, chainId).tag(CHAIN_NAME_TAG, chainName).tag(EXECUTION_STATUS_TAG, executionStatus).tag(CHAIN_STATUS_CODE_TAG, chainStatusCode).tag(SNAPSHOT_NAME_TAG, snapshotName).tag(ENGINE_DOMAIN_TAG, this.serverConfiguration.getDomain()).register(this.meterRegistry);
    }

    private DistributionSummary newHttpPayloadSizeDistributionSummary(boolean isRequest, String chainId, String chainName, String elementId, String elementName, String elementType) {
        String metricName = switch (1.$SwitchMap$org$qubership$integration$platform$engine$model$ChainElementType[ChainElementType.fromString((String)elementType).ordinal()]) {
            case 1 -> {
                if (isRequest) {
                    yield this.namePrefix + HTTP_TRIGGER_REQUEST_PAYLOAD_SIZE_NAME;
                }
                yield this.namePrefix + HTTP_TRIGGER_RESPONSE_PAYLOAD_SIZE_NAME;
            }
            case 2, 3 -> {
                if (isRequest) {
                    yield this.namePrefix + HTTP_SENDERS_REQUEST_PAYLOAD_SIZE_NAME;
                }
                yield this.namePrefix + HTTP_SENDERS_RESPONSE_PAYLOAD_SIZE_NAME;
            }
            default -> "";
        };
        return DistributionSummary.builder((String)metricName).tag(CHAIN_ID_TAG, chainId).tag(CHAIN_NAME_TAG, chainName).tag(ELEMENT_ID_TAG, elementId).tag(ELEMENT_NAME_TAG, elementName).tag(ELEMENT_TYPE_TAG, elementType).tag(ENGINE_DOMAIN_TAG, this.serverConfiguration.getDomain()).distributionStatisticExpiry(Duration.ofMinutes(1L)).baseUnit("bytes").serviceLevelObjectives(this.httpPayloadMetricsBuckets).publishPercentileHistogram().register(this.meterRegistry);
    }

    private void processChainDataAllocationSize(String metricName, ConcurrentMap<String, AtomicLong> metricMap, List<ChainDataAllocationSize> chainDataAllocationSizes) {
        ArrayList inboundChainMapKeys = new ArrayList();
        chainDataAllocationSizes.forEach(chainAllocationSize -> {
            String chainMapKey = this.buildChainMapKey(chainAllocationSize.getChainId(), chainAllocationSize.getChainName());
            inboundChainMapKeys.add(chainMapKey);
            if (metricMap.getOrDefault(chainMapKey, null) != null) {
                ((AtomicLong)metricMap.get(chainMapKey)).set(chainAllocationSize.getAllocatedSize());
            } else {
                Tag chainIdTag = Tag.of((String)CHAIN_ID_TAG, (String)chainAllocationSize.getChainId());
                Tag chainNameTag = Tag.of((String)CHAIN_NAME_TAG, (String)chainAllocationSize.getChainName());
                metricMap.put(chainMapKey, (AtomicLong)this.meterRegistry.gauge(metricName, List.of(chainIdTag, chainNameTag), (Number)new AtomicLong(chainAllocationSize.getAllocatedSize())));
            }
        });
        List<String> chainMapKeysToReset = metricMap.keySet().stream().filter(chainMapKey -> !inboundChainMapKeys.contains(chainMapKey)).toList();
        chainMapKeysToReset.forEach(chainMapKey -> ((AtomicLong)metricMap.get(chainMapKey)).set(0L));
    }

    private String buildChainMapKey(String chainId, String chainName) {
        return chainId + "__" + chainName;
    }

    public boolean isMetricsEnabled() {
        return this.metricsEnabled;
    }

    public boolean isHttpPayloadMetricsEnabled() {
        return this.httpPayloadMetricsEnabled;
    }

    public double[] getHttpPayloadMetricsBuckets() {
        return this.httpPayloadMetricsBuckets;
    }

    public MeterRegistry getMeterRegistry() {
        return this.meterRegistry;
    }
}

