/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service.debugger.util;

import java.util.Collection;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.qubership.integration.platform.engine.model.constants.CamelConstants;
import org.qubership.integration.platform.engine.model.deployment.properties.CamelDebuggerProperties;
import org.qubership.integration.platform.engine.model.logging.LogPayload;
import org.qubership.integration.platform.engine.service.ExecutionStatus;

public class DebuggerUtils {
    private static final String ELEMENT_STEP_PREFIX = "--";

    public static boolean isFailedOperation(Exchange exchange) {
        return exchange.getException() != null;
    }

    public static String getNodeIdFormatted(String nodeId) {
        return CamelConstants.CUSTOM_STEP_ID_PATTERN.matcher(nodeId).matches() ? CamelConstants.NAME_STEP_REG_EXP_PATTERN.matcher(nodeId).replaceAll("") : nodeId;
    }

    public static String getStepChainElementId(String fullStepId) {
        if (fullStepId.contains(ELEMENT_STEP_PREFIX)) {
            return fullStepId.substring(fullStepId.indexOf(ELEMENT_STEP_PREFIX) + ELEMENT_STEP_PREFIX.length());
        }
        return "";
    }

    public static String getStepNameFormatted(String nodeId) {
        return CamelConstants.CUSTOM_STEP_ID_PATTERN.matcher(nodeId).matches() ? CamelConstants.UUID_STEP_REG_EXP_PATTERN.matcher(nodeId).replaceAll("") : nodeId;
    }

    public static ExecutionStatus extractExecutionStatus(Exchange exchange) {
        AtomicBoolean overallStatusWarn = (AtomicBoolean)exchange.getProperty("internalProperty_overall_status_warning", AtomicBoolean.class);
        boolean isWarn = Boolean.TRUE.equals(exchange.getProperty("internalProperty_element_warning", Boolean.class));
        if (overallStatusWarn != null) {
            boolean bl = isWarn = isWarn || overallStatusWarn.get();
        }
        if (isWarn) {
            return ExecutionStatus.COMPLETED_WITH_WARNINGS;
        }
        Throwable caughtException = (Throwable)exchange.getProperty(ExchangePropertyKey.EXCEPTION_CAUGHT, Throwable.class);
        Throwable lastException = (Throwable)exchange.getProperty("internalProperty_lastException", Throwable.class);
        Boolean sessionFailed = (Boolean)exchange.getProperty("internalProperty_sessionFailed", (Object)Boolean.FALSE, Boolean.class);
        if (caughtException != null || sessionFailed.booleanValue() || lastException != null) {
            return ExecutionStatus.COMPLETED_WITH_ERRORS;
        }
        return ExecutionStatus.COMPLETED_NORMALLY;
    }

    public static void removeStepPropertyFromAllExchanges(Exchange exchange, String sessionElementId) {
        String sessionId = (String)exchange.getProperty("internalProperty_sessionId", String.class);
        ConcurrentMap exchanges = (ConcurrentMap)((ConcurrentMap)exchange.getProperty("internalProperty_exchanges", ConcurrentMap.class)).get(sessionId);
        if (exchanges != null) {
            exchanges.forEach((id, value) -> ((Deque)value.getProperty("internalProperty_steps", Deque.class)).removeIf(step -> step.equals(sessionElementId)));
        }
    }

    public static String chooseLogPayload(Exchange exchange, String body, CamelDebuggerProperties dbgProperties) {
        if (dbgProperties.getRuntimeProperties(exchange).getLogPayload() != null) {
            return dbgProperties.getRuntimeProperties(exchange).getLogPayload().contains(LogPayload.BODY) ? body : "<body not logged>";
        }
        return dbgProperties.getRuntimeProperties(exchange).isLogPayloadEnabled() ? body : "<body not logged>";
    }

    public static void initInternalExchangeVariables(Exchange exchange) {
        exchange.setProperty("internalProperty_steps", exchange.getProperty("internalProperty_steps") == null ? new ConcurrentLinkedDeque() : new ConcurrentLinkedDeque((Collection)exchange.getProperty("internalProperty_steps", ConcurrentLinkedDeque.class)));
        exchange.setProperty("internalProperty_exchanges", exchange.getProperty("internalProperty_exchanges") == null ? new ConcurrentHashMap() : new ConcurrentHashMap((Map)exchange.getProperty("internalProperty_exchanges", ConcurrentHashMap.class)));
        exchange.setProperty("internalProperty_exchangeStartTimeMs", (Object)System.currentTimeMillis());
    }

    public static String getNodeIdForExecutionMap(String nodeId, String splitId) {
        return splitId == null ? nodeId : nodeId + splitId;
    }

    public static Throwable getExceptionFromExchange(Exchange exchange) {
        Throwable exception = (Throwable)exchange.getProperty(ExchangePropertyKey.EXCEPTION_CAUGHT, Throwable.class);
        if (exception == null) {
            exception = (Throwable)exchange.getProperty("internalProperty_lastException", Throwable.class);
        }
        if (exception == null) {
            exception = exchange.getException();
        }
        return exception;
    }

    public static void setOverallWarning(Exchange exchange, boolean value) {
        AtomicBoolean overallStatusWarn = (AtomicBoolean)exchange.getProperty("internalProperty_overall_status_warning", AtomicBoolean.class);
        if (overallStatusWarn != null) {
            overallStatusWarn.set(value);
        }
    }
}

