/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service.deployment.processing.actions.context.before;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.util.Map;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.engine.errorhandling.DeploymentRetriableException;
import org.qubership.integration.platform.engine.model.ChainElementType;
import org.qubership.integration.platform.engine.model.constants.ConnectionSourceType;
import org.qubership.integration.platform.engine.model.constants.EnvironmentSourceType;
import org.qubership.integration.platform.engine.model.deployment.update.DeploymentInfo;
import org.qubership.integration.platform.engine.model.deployment.update.ElementProperties;
import org.qubership.integration.platform.engine.service.VariablesService;
import org.qubership.integration.platform.engine.service.deployment.processing.ElementProcessingAction;
import org.qubership.integration.platform.engine.service.deployment.processing.qualifiers.OnBeforeDeploymentContextCreated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@ConditionalOnProperty(name={"qip.camel.component.rabbitmq.predeploy-check-enabled"}, havingValue="true", matchIfMissing=true)
@OnBeforeDeploymentContextCreated
public class AmpqConnectionCheckAction
extends ElementProcessingAction {
    private static final Logger log = LoggerFactory.getLogger(AmpqConnectionCheckAction.class);
    private final VariablesService variablesService;

    @Autowired
    public AmpqConnectionCheckAction(VariablesService variablesService) {
        this.variablesService = variablesService;
    }

    public boolean applicableTo(ElementProperties properties) {
        Map props = properties.getProperties();
        ChainElementType chainElementType = ChainElementType.fromString((String)((String)props.get("elementType")));
        String connectionSourceType = (String)props.get("connectionSourceType");
        String operationProtocolType = this.getProp(props, "integrationOperationProtocolType");
        return ChainElementType.isAmqpAsyncElement((ChainElementType)chainElementType) && (AmpqConnectionCheckAction.equalsIgnoreCase((Enum)ConnectionSourceType.MAAS, (String)connectionSourceType) || AmpqConnectionCheckAction.equalsIgnoreCase((Enum)EnvironmentSourceType.MAAS_BY_CLASSIFIER, (String)connectionSourceType)) && (!AmpqConnectionCheckAction.equalsIgnoreCase((Enum)ChainElementType.ASYNCAPI_TRIGGER, (String)chainElementType.name()) && !AmpqConnectionCheckAction.equalsIgnoreCase((Enum)ChainElementType.SERVICE_CALL, (String)chainElementType.name()) || "amqp".equals(operationProtocolType));
    }

    public void apply(SpringCamelContext context, ElementProperties elementProperties, DeploymentInfo deploymentInfo) {
        ChainElementType chainElementType = ChainElementType.fromString((String)((String)elementProperties.getProperties().get("elementType")));
        try {
            Map props = elementProperties.getProperties();
            boolean isProducerElement = ChainElementType.isAmqpProducerElement((ChainElementType)chainElementType);
            String exchange = this.getProp(props, "exchange");
            String queues = this.getProp(props, "queues");
            String addresses = this.getProp(props, "addresses");
            String username = this.getProp(props, "username");
            String password = this.getProp(props, "password");
            String vhost = this.getProp(props, "vhost");
            String ssl = this.getProp(props, "sslProtocol");
            if (StringUtils.isBlank((CharSequence)exchange) || StringUtils.isBlank((CharSequence)addresses)) {
                throw new IllegalArgumentException("AMQP mandatory parameters are missing, check configuration");
            }
            if (!addresses.matches("^[\\w.,:\\-_]+$")) {
                throw new IllegalArgumentException("AMQP addresses has invalid format, check configuration");
            }
            ConnectionFactory factory = new ConnectionFactory();
            factory.setUri((StringUtils.isNotBlank((CharSequence)ssl) && ssl.equals("true") ? "amqps://" : "amqp://") + addresses);
            if (StringUtils.isNotBlank((CharSequence)username)) {
                factory.setUsername(username);
            }
            if (StringUtils.isNotBlank((CharSequence)password)) {
                factory.setPassword(password);
            }
            if (StringUtils.isNotBlank((CharSequence)vhost)) {
                factory.setVirtualHost(vhost);
            }
            try (Connection connection = factory.newConnection();){
                Channel channel = connection.createChannel();
                try {
                    if (isProducerElement) {
                        channel.exchangeDeclarePassive(exchange);
                    } else {
                        channel.queueDeclarePassive(queues);
                    }
                }
                catch (IOException e) {
                    throw new DeploymentRetriableException("AMQP " + (isProducerElement ? "exchange " + exchange : "queue(s) " + queues) + " not found, check configuration");
                }
            }
            catch (IOException e) {
                throw new DeploymentRetriableException("Connection configuration is invalid or broker is unavailable", (Exception)e);
            }
        }
        catch (IllegalArgumentException e) {
            log.error("AMQP predeploy check is failed", (Throwable)e);
            throw e;
        }
        catch (DeploymentRetriableException e) {
            log.warn("AMQP predeploy check is failed with retriable exception", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.warn("Failed to check amqp connection for deployment: {}, element: {}", new Object[]{deploymentInfo.getDeploymentId(), elementProperties.getElementId(), e});
        }
    }

    private static <E extends Enum<E>> boolean equalsIgnoreCase(E e, String s) {
        return e.name().equalsIgnoreCase(s);
    }

    private String getProp(Map<String, String> properties, String name) {
        return this.variablesService.injectVariables(properties.get(name));
    }
}

