/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service.deployment.processing.actions.context.before;

import java.sql.Connection;
import javax.sql.DataSource;
import org.apache.camel.spring.SpringCamelContext;
import org.qubership.integration.platform.engine.errorhandling.DeploymentRetriableException;
import org.qubership.integration.platform.engine.model.deployment.update.DeploymentConfiguration;
import org.qubership.integration.platform.engine.model.deployment.update.DeploymentInfo;
import org.qubership.integration.platform.engine.service.deployment.processing.DeploymentProcessingAction;
import org.qubership.integration.platform.engine.service.deployment.processing.qualifiers.OnBeforeDeploymentContextCreated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@OnBeforeDeploymentContextCreated
public class SchedulerRequirementsCheckAction
implements DeploymentProcessingAction {
    private static final Logger log = LoggerFactory.getLogger(SchedulerRequirementsCheckAction.class);
    private final DataSource qrtzDataSource;

    @Autowired
    public SchedulerRequirementsCheckAction(@Qualifier(value="qrtzDataSource") DataSource qrtzDataSource) {
        this.qrtzDataSource = qrtzDataSource;
    }

    public void execute(SpringCamelContext context, DeploymentInfo deploymentInfo, DeploymentConfiguration deploymentConfiguration) {
        if (deploymentInfo.isContainsSchedulerElements()) {
            this.checkSchedulerRequirements();
        }
    }

    private void checkSchedulerRequirements() {
        if (!this.isSchedulerDatabaseReady()) {
            log.warn("Failed to obtain DB connection for scheduler");
            throw new DeploymentRetriableException("Failed to obtain DB connection for scheduler");
        }
        log.debug("Scheduler database is ready");
    }

    private boolean isSchedulerDatabaseReady() {
        boolean bl;
        block8: {
            Connection conn = this.qrtzDataSource.getConnection();
            try {
                boolean bl2 = bl = conn != null;
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.warn("Scheduler database not ready", (Throwable)e);
                    return false;
                }
            }
            conn.close();
        }
        return bl;
    }
}

