/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service.deployment.processing.actions.context.before;

import org.apache.camel.spring.SpringCamelContext;
import org.qubership.integration.platform.engine.errorhandling.DeploymentRetriableException;
import org.qubership.integration.platform.engine.model.ChainElementType;
import org.qubership.integration.platform.engine.model.deployment.update.DeploymentInfo;
import org.qubership.integration.platform.engine.model.deployment.update.ElementProperties;
import org.qubership.integration.platform.engine.service.SdsService;
import org.qubership.integration.platform.engine.service.deployment.processing.ElementProcessingAction;
import org.qubership.integration.platform.engine.service.deployment.processing.qualifiers.OnBeforeDeploymentContextCreated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnBean(value={SdsService.class})
@OnBeforeDeploymentContextCreated
public class SdsConnectionCheckAction
extends ElementProcessingAction {
    private static final Logger log = LoggerFactory.getLogger(SdsConnectionCheckAction.class);
    private final SdsService sdsService;

    @Autowired
    public SdsConnectionCheckAction(SdsService sdsService) {
        this.sdsService = sdsService;
    }

    public boolean applicableTo(ElementProperties properties) {
        ChainElementType chainElementType = ChainElementType.fromString((String)((String)properties.getProperties().get("elementType")));
        return ChainElementType.isSdsTriggerElement((ChainElementType)chainElementType);
    }

    public void apply(SpringCamelContext context, ElementProperties properties, DeploymentInfo deploymentInfo) {
        try {
            this.sdsService.getJobsMetadata();
        }
        catch (Exception exception) {
            log.warn("Sds trigger predeploy check failed. Please check scheduling-service");
            throw new DeploymentRetriableException("Sds trigger predeploy check failed. Please check scheduling-service", exception);
        }
    }
}

