/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.util;

import io.atlasmap.spi.AtlasActionProcessor;
import io.atlasmap.spi.AtlasFieldAction;
import io.atlasmap.v2.FieldType;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import java.util.UUID;
import org.qubership.integration.platform.engine.util.AtlasMapUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class AtlasMapUtils
implements AtlasFieldAction {
    @AtlasActionProcessor(sourceType=FieldType.ANY)
    public static String getuuid(QIPGetUUID action, String input) {
        return UUID.randomUUID().toString();
    }

    @AtlasActionProcessor(sourceType=FieldType.ANY)
    public static String currentTime(QIPCurrentTime action, String input) {
        return AtlasMapUtils.convertDateFormat((Boolean)action.getReturnUnixTimeOutput(), (String)action.getOutputFormat(), (String)action.getOutputTimezone(), (String)action.getOutputLocale(), (long)Instant.now().getEpochSecond());
    }

    @AtlasActionProcessor(sourceType=FieldType.ANY)
    public static String currentDate(QIPCurrentDate action, String input) {
        return AtlasMapUtils.convertDateFormat((Boolean)action.getReturnUnixTimeOutput(), (String)action.getOutputFormat(), (String)action.getOutputTimezone(), (String)action.getOutputLocale(), (long)Instant.now().getEpochSecond());
    }

    @AtlasActionProcessor(sourceType=FieldType.ANY)
    public static String currentDateTime(QIPCurrentDateTime action, String input) {
        return AtlasMapUtils.convertDateFormat((Boolean)action.getReturnUnixTimeOutput(), (String)action.getOutputFormat(), (String)action.getOutputTimezone(), (String)action.getOutputLocale(), (long)Instant.now().getEpochSecond());
    }

    @AtlasActionProcessor(sourceType=FieldType.ANY)
    public static Object defaultValue(QIPDefaultValue action, Object input) {
        if (input instanceof String) {
            input = ((String)input).isBlank() ? null : input;
        }
        return input == null ? action.getDefaultValue() : input;
    }

    @AtlasActionProcessor(sourceType=FieldType.STRING)
    public static String formatDateTime(QIPFormatDateTime action, String input) {
        return AtlasMapUtils.convertDateFormat((Boolean)action.getReturnUnixTimeInput(), (String)action.getInputFormat(), (String)action.getInputLocale(), (String)action.getInputTimezone(), (Boolean)action.getReturnUnixTimeOutput(), (String)action.getOutputFormat(), (String)action.getOutputLocale(), (String)action.getOutputTimezone(), (String)input);
    }

    @AtlasActionProcessor(sourceType=FieldType.STRING)
    public static String lookupValue(QIPDictionary action, String input) {
        return action.getDictionary().getOrDefault(input, action.defaultValue);
    }

    private static String convertDateFormat(Boolean returnUnixTimeOutput, String outputFormat, String outputLocale, String outputTimezone, long input) {
        if (returnUnixTimeOutput.booleanValue()) {
            return String.valueOf(input);
        }
        return AtlasMapUtils.convertDateFormat((Boolean)true, (String)outputFormat, (String)outputLocale, (String)outputTimezone, (Boolean)false, (String)outputFormat, (String)outputLocale, (String)outputTimezone, (String)String.valueOf(input));
    }

    public static String convertDateFormat(Boolean returnUnixTimeInput, String inputFormat, String inputLocale, String inputTimezone, Boolean returnUnixTimeOutput, String outputFormat, String outputLocale, String outputTimezone, String input) {
        DateTimeFormatter inputFormatter = AtlasMapUtils.getTimeFormatter((String)inputFormat, (String)inputLocale, (String)inputTimezone);
        DateTimeFormatter outputFormatter = AtlasMapUtils.getTimeFormatter((String)outputFormat, (String)outputLocale, (String)outputTimezone);
        if (returnUnixTimeInput.booleanValue()) {
            return returnUnixTimeOutput != false ? input : Instant.ofEpochSecond(Long.parseLong(input)).atZone(ZoneId.of("UTC")).format(outputFormatter);
        }
        TemporalAccessorWithDefaultTimeAndZone accessor = new TemporalAccessorWithDefaultTimeAndZone(inputFormatter.parse(input));
        ZonedDateTime zonedDateTime = ZonedDateTime.from((TemporalAccessor)accessor);
        if (returnUnixTimeOutput.booleanValue()) {
            Instant instant = Instant.from(zonedDateTime);
            long epochSeconds = instant.toEpochMilli() / 1000L;
            return String.valueOf(epochSeconds);
        }
        return outputFormatter.format(zonedDateTime);
    }

    private static DateTimeFormatter getTimeFormatter(String pattern, String localeAsString, String timeZoneAsString) {
        DateTimeFormatter dateTimeFormatter;
        DateTimeFormatter dateTimeFormatter2 = dateTimeFormatter = pattern.isBlank() ? DateTimeFormatter.BASIC_ISO_DATE : DateTimeFormatter.ofPattern(pattern);
        if (!timeZoneAsString.isBlank()) {
            ZoneId zoneId = ZoneId.of(timeZoneAsString);
            dateTimeFormatter = dateTimeFormatter.withZone(zoneId);
        }
        if (!localeAsString.isBlank()) {
            String[] localeComponents = localeAsString.split("_");
            Locale locale = new Locale.Builder().setLanguage(localeComponents[0]).setRegion(localeComponents[1]).build();
            dateTimeFormatter = dateTimeFormatter.withLocale(locale);
        } else {
            dateTimeFormatter = dateTimeFormatter.withLocale(Locale.US);
        }
        return dateTimeFormatter;
    }

    public static String getQueryParameters(String uri) {
        return uri.contains("?") ? uri.split("\\?", 2)[1] : "";
    }
}

