/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.util;

import java.util.Map;
import org.apache.camel.Exchange;
import org.qubership.integration.platform.engine.util.CheckpointUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriTemplate;

public class CheckpointUtils {
    private static final Logger log = LoggerFactory.getLogger(CheckpointUtils.class);
    public static final String SESSION_RETRY_PATH_TEMPLATE = "/chains/{checkpointChainId}/sessions/{checkpointSessionId}/retry";
    public static final String CHECKPOINT_RETRY_PATH_TEMPLATE = "/chains/{checkpointChainId}/sessions/{checkpointSessionId}/checkpoint-elements/{checkpointElementId}/retry";
    public static final String CHECKPOINT_CHAIN_ID_PATH_VAR = "checkpointChainId";
    public static final String CHECKPOINT_SESSION_ID_PATH_VAR = "checkpointSessionId";
    public static final String CHECKPOINT_ELEMENT_ID_PATH_VAR = "checkpointElementId";

    private CheckpointUtils() {
    }

    public static CheckpointInfo extractTriggeredCheckpointInfo(Exchange exchange) {
        Map pathVariables = new UriTemplate(CHECKPOINT_RETRY_PATH_TEMPLATE).match((String)exchange.getMessage().getHeader("CamelHttpPath", (Object)"", String.class));
        String chainId = (String)pathVariables.get(CHECKPOINT_CHAIN_ID_PATH_VAR);
        String sessionId = (String)pathVariables.get(CHECKPOINT_SESSION_ID_PATH_VAR);
        String checkpointElementId = (String)pathVariables.get(CHECKPOINT_ELEMENT_ID_PATH_VAR);
        return chainId != null && sessionId != null && checkpointElementId != null ? new CheckpointInfo(chainId, sessionId, checkpointElementId) : null;
    }

    public static void setSessionProperties(Exchange exchange, String parentSessionId, String originalSessionId) {
        exchange.setProperty("parentSessionId", (Object)parentSessionId);
        exchange.setProperty("internalProperty_parentSessionId", (Object)parentSessionId);
        exchange.setProperty("originalSessionId", (Object)originalSessionId);
        exchange.setProperty("internalProperty_originalSessionId", (Object)originalSessionId);
    }
}

