/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.util.paths;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.engine.util.paths.PathElement;

public class PathParser {
    private static final String SEPARATOR = "/";
    private static final char PLACEHOLDER_START = '{';
    private static final char PLACEHOLDER_END = '}';

    public List<PathElement> parse(String pathString) {
        String strippedPath = StringUtils.strip((String)pathString, (String)SEPARATOR);
        return strippedPath.isEmpty() ? Collections.emptyList() : Arrays.stream(strippedPath.split(SEPARATOR)).map(arg_0 -> this.parseElement(arg_0)).collect(Collectors.toList());
    }

    public PathElement parseElement(String elementString) {
        StringBuilder patternBuilder = new StringBuilder();
        boolean inPlaceholder = false;
        for (int i = 0; i < elementString.length(); ++i) {
            char c = elementString.charAt(i);
            if (c == '{') {
                inPlaceholder = true;
                patternBuilder.append('\u0000');
                continue;
            }
            if (c == '}') {
                inPlaceholder = false;
                continue;
            }
            if (inPlaceholder) continue;
            patternBuilder.append(c);
        }
        return new PathElement(patternBuilder.toString());
    }
}

