/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.processors;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.qubership.integration.platform.engine.service.contextstorage.ContextStorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ContextStorageProcessor
implements Processor {
    private static final Logger log = LoggerFactory.getLogger(ContextStorageProcessor.class);
    private static final String SESSION_CONTEXT_PROPERTY_PREFIX = "internalProperty_contextStorage_";
    private static final String PROPERTY_USE_CORRELATION_ID = "internalProperty_contextStorage_useCorrelationId";
    private static final String PROPERTY_CONTEXT_ID = "internalProperty_contextStorage_contextId";
    private static final String PROPERTY_CONTEXT_SERVICE_ID = "internalProperty_contextStorage_contextServiceId";
    private static final String PROPERTY_OPERATION = "internalProperty_contextStorage_operation";
    private static final String PROPERTY_KEY = "internalProperty_contextStorage_key";
    private static final String PROPERTY_VALUE = "internalProperty_contextStorage_value";
    private static final String PROPERTY_TTL = "internalProperty_contextStorage_ttl";
    private static final String PROPERTY_KEYS = "internalProperty_contextStorage_keys";
    private static final String PROPERTY_TARGET = "internalProperty_contextStorage_target";
    private static final String PROPERTY_TARGET_NAME = "internalProperty_contextStorage_targetName";
    private static final String PROPERTY_UNWRAP = "internalProperty_contextStorage_unwrap";
    private final ContextStorageService contextStorageService;

    @Autowired
    public ContextStorageProcessor(ContextStorageService contextStorageService) {
        this.contextStorageService = contextStorageService;
    }

    public void process(Exchange exchange) throws Exception {
        String sessionId = this.getContextSessionId(exchange);
        Operation operation = this.readEnumValue(exchange, PROPERTY_OPERATION, Operation.class);
        switch (operation.ordinal()) {
            case 0: {
                this.processGetValue(exchange, sessionId);
                break;
            }
            case 1: {
                this.processSetValue(exchange, sessionId);
                break;
            }
            case 2: {
                this.deleteContext(exchange, sessionId);
            }
        }
    }

    private void processGetValue(Exchange exchange, String sessionId) throws Exception {
        String contextServiceId = (String)exchange.getProperty(PROPERTY_CONTEXT_SERVICE_ID, String.class);
        String contextId = Optional.ofNullable((String)exchange.getProperty(PROPERTY_CONTEXT_ID, String.class)).orElse(sessionId);
        List<String> contextKey = Optional.ofNullable((String)exchange.getProperty(PROPERTY_KEYS, String.class)).map(value -> List.of(value.split(","))).orElse(List.of());
        Target target = this.readEnumValue(exchange, PROPERTY_TARGET, Target.class);
        String name = (String)exchange.getProperty(PROPERTY_TARGET_NAME, String.class);
        boolean unwrap = !exchange.getProperty(PROPERTY_UNWRAP).toString().isEmpty() ? (Boolean)exchange.getProperty(PROPERTY_UNWRAP, Boolean.class) : false;
        Map<String, String> map = this.contextStorageService.getValue(contextServiceId, contextId, contextKey);
        switch (target.ordinal()) {
            case 2: {
                exchange.getMessage().setBody(unwrap ? map.values().stream().findFirst().orElse(null) : map);
                break;
            }
            case 0: {
                exchange.getMessage().setHeader(name, unwrap ? map.values().stream().findFirst().orElse(null) : map);
                break;
            }
            case 1: {
                exchange.setProperty(name, unwrap ? map.values().stream().findFirst().orElse(null) : map);
            }
        }
    }

    private void processSetValue(Exchange exchange, String sessionId) throws Exception {
        String contextKey = (String)exchange.getProperty(PROPERTY_KEY, String.class);
        String contextValue = (String)exchange.getProperty(PROPERTY_VALUE, String.class);
        String contextServiceId = (String)exchange.getProperty(PROPERTY_CONTEXT_SERVICE_ID, String.class);
        String contextId = Optional.ofNullable((String)exchange.getProperty(PROPERTY_CONTEXT_ID, String.class)).orElse(sessionId);
        long ttl = (Long)exchange.getProperty(PROPERTY_TTL, Long.class);
        this.contextStorageService.storeValue(contextKey, contextValue, contextServiceId, contextId, ttl);
    }

    private void deleteContext(Exchange exchange, String sessionId) throws Exception {
        String contextServiceId = (String)exchange.getProperty(PROPERTY_CONTEXT_SERVICE_ID, String.class);
        String contextId = Optional.ofNullable((String)exchange.getProperty(PROPERTY_CONTEXT_ID, String.class)).orElse(sessionId);
        this.contextStorageService.deleteValue(contextServiceId, contextId);
    }

    private <T extends Enum<T>> T readEnumValue(Exchange exchange, String propertyName, Class<T> cls) {
        return (T)((Enum)Optional.ofNullable((String)exchange.getProperty(propertyName, String.class)).map(value -> Enum.valueOf(cls, value.toUpperCase())).orElse(null));
    }

    private String getContextSessionId(Exchange exchange) {
        boolean useCorrelationId = (Boolean)exchange.getProperty(PROPERTY_USE_CORRELATION_ID, Boolean.class);
        return useCorrelationId ? (String)exchange.getProperty("correlationId", String.class) : (String)exchange.getProperty(PROPERTY_CONTEXT_ID, String.class);
    }

    static enum Operation {
        GET,
        SET,
        DELETE;

    }

    static enum Target {
        HEADER,
        PROPERTY,
        BODY;

    }
}

