/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.processors;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.qubership.integration.platform.engine.camel.JsonMessageValidator;
import org.qubership.integration.platform.engine.service.debugger.util.MessageHelper;
import org.qubership.integration.platform.engine.util.ExchangeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KafkaTriggerProcessor
implements Processor {
    private final JsonMessageValidator validator;

    @Autowired
    public KafkaTriggerProcessor(JsonMessageValidator jsonMessageValidator) {
        this.validator = jsonMessageValidator;
    }

    public void process(Exchange exchange) throws Exception {
        String asyncValidationSchema = (String)exchange.getProperty("internalProperty_asyncValidationSchema");
        ExchangeUtils.setContentTypeIfMissing(exchange);
        if (asyncValidationSchema != null && !asyncValidationSchema.isEmpty()) {
            String inputJsonMessage = MessageHelper.extractBody(exchange);
            this.validator.validate(inputJsonMessage, asyncValidationSchema);
        }
    }
}

