/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.processors;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.language.simple.SimpleLanguage;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.engine.model.logging.LogLoggingLevel;
import org.qubership.integration.platform.engine.service.debugger.logging.ChainLogger;
import org.qubership.integration.platform.engine.util.MDCUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LogRecordProcessor
implements Processor {
    private static final Logger log = LoggerFactory.getLogger(LogRecordProcessor.class);
    private static final String LOG_RECORD_PROPERTY_PREFIX = "internalProperty_logRecord_";
    private static final String PROPERTY_LOG_LEVEL = "internalProperty_logRecord_logLevel";
    private static final String PROPERTY_SENDER = "internalProperty_logRecord_sender";
    private static final String PROPERTY_RECEIVER = "internalProperty_logRecord_receiver";
    private static final String PROPERTY_BUSINESS_IDENTIFIERS = "internalProperty_logRecord_businessIdentifiers";
    private static final String PROPERTY_MESSAGE = "internalProperty_logRecord_message";
    private final ChainLogger chainLogger;
    private final SimpleLanguage simpleInterpreter;

    @Autowired
    public LogRecordProcessor(ChainLogger chainLogger, SimpleLanguage simpleInterpreter) {
        this.chainLogger = chainLogger;
        this.simpleInterpreter = simpleInterpreter;
    }

    public void process(Exchange exchange) throws Exception {
        this.createLogRecord(exchange);
    }

    private void createLogRecord(Exchange exchange) {
        LogLevel logLevel = Optional.of((String)exchange.getProperty(PROPERTY_LOG_LEVEL, String.class)).map(value -> Enum.valueOf(LogLevel.class, value.toUpperCase())).orElse(null);
        String sender = (String)exchange.getProperty(PROPERTY_SENDER, String.class);
        String receiver = (String)exchange.getProperty(PROPERTY_RECEIVER, String.class);
        String message = (String)exchange.getProperty(PROPERTY_MESSAGE, String.class);
        Map<Object, Object> businessIdentifiers = new HashMap<Object, Object>();
        if (StringUtils.isNotBlank((CharSequence)((String)exchange.getProperty(PROPERTY_BUSINESS_IDENTIFIERS)))) {
            businessIdentifiers = (Map)exchange.getProperty(PROPERTY_BUSINESS_IDENTIFIERS, Map.class);
        }
        businessIdentifiers.replaceAll((k, v) -> this.evaluateSimpleExpression(exchange, v.toString()));
        String logRecordMessage = this.constructLogRecordMessage(sender, receiver, message);
        if (!businessIdentifiers.isEmpty()) {
            MDCUtil.setBusinessIds(businessIdentifiers);
        }
        LogLoggingLevel globalLogLevel = LogLoggingLevel.defaultLevel();
        switch (logLevel.ordinal()) {
            case 0: {
                this.chainLogger.error(logRecordMessage, new Object[0]);
                break;
            }
            case 1: {
                if (!globalLogLevel.isWarnLevel()) break;
                this.chainLogger.warn(logRecordMessage, new Object[0]);
                break;
            }
            case 2: {
                if (!globalLogLevel.isInfoLevel()) break;
                this.chainLogger.info(logRecordMessage, new Object[0]);
            }
        }
        MDC.remove((String)"businessIdentifiers");
    }

    private String constructLogRecordMessage(String sender, String receiver, String message) {
        Object recordMessage = "";
        if (!StringUtils.isEmpty((CharSequence)sender)) {
            recordMessage = String.format("[sender=%-16s]", sender);
        }
        if (!StringUtils.isEmpty((CharSequence)receiver)) {
            recordMessage = (String)recordMessage + this.setDelimiterIfNeeded((String)recordMessage) + String.format("[receiver=%-16s]", receiver);
        }
        return (String)recordMessage + this.setDelimiterIfNeeded((String)recordMessage) + message;
    }

    private String evaluateSimpleExpression(Exchange exchange, String str) {
        return (String)this.simpleInterpreter.createExpression(str).evaluate(exchange, String.class);
    }

    private String setDelimiterIfNeeded(String text) {
        return !StringUtils.isEmpty((CharSequence)text) ? " " : "";
    }

    static enum LogLevel {
        ERROR,
        WARNING,
        INFO;

    }
}

