/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.rest.v1.dto.checkpoint;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import org.qubership.integration.platform.engine.rest.v1.dto.checkpoint.CheckpointDTO;
import org.qubership.integration.platform.engine.service.ExecutionStatus;

@Schema(description="Single chain session with available checkpoints list")
public class CheckpointSessionDTO {
    @Schema(description="Id of the session")
    private String id;
    @Schema(description="Date time of session start")
    private String started;
    @Schema(description="Date time of session end")
    private String finished;
    @Schema(description="Duration of session execution, in ms")
    private Long duration;
    @Schema(description="Duration of session execution, in ms")
    private ExecutionStatus executionStatus;
    @Schema(description="Id of the chain it was executed on")
    private String chainId;
    @Schema(description="Name of the chain it was executed on")
    private String chainName;
    @Schema(description="engine pod ip address on which chain was executed")
    private String engineAddress;
    @Schema(description="Value of logging level on a chain at a time chain was executed")
    private String loggingLevel;
    @Schema(description="Deployed snapshot name for the chain")
    private String snapshotName;
    @Schema(description="Correlation id for that execution (if it was set)")
    private String correlationId;
    @Schema(description="List of available checkpoints for that session")
    List<CheckpointDTO> checkpoints;

    CheckpointSessionDTO(String id, String started, String finished, Long duration, ExecutionStatus executionStatus, String chainId, String chainName, String engineAddress, String loggingLevel, String snapshotName, String correlationId, List<CheckpointDTO> checkpoints) {
        this.id = id;
        this.started = started;
        this.finished = finished;
        this.duration = duration;
        this.executionStatus = executionStatus;
        this.chainId = chainId;
        this.chainName = chainName;
        this.engineAddress = engineAddress;
        this.loggingLevel = loggingLevel;
        this.snapshotName = snapshotName;
        this.correlationId = correlationId;
        this.checkpoints = checkpoints;
    }

    public static CheckpointSessionDTOBuilder builder() {
        return new CheckpointSessionDTOBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getStarted() {
        return this.started;
    }

    public String getFinished() {
        return this.finished;
    }

    public Long getDuration() {
        return this.duration;
    }

    public ExecutionStatus getExecutionStatus() {
        return this.executionStatus;
    }

    public String getChainId() {
        return this.chainId;
    }

    public String getChainName() {
        return this.chainName;
    }

    public String getEngineAddress() {
        return this.engineAddress;
    }

    public String getLoggingLevel() {
        return this.loggingLevel;
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public List<CheckpointDTO> getCheckpoints() {
        return this.checkpoints;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setStarted(String started) {
        this.started = started;
    }

    public void setFinished(String finished) {
        this.finished = finished;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public void setExecutionStatus(ExecutionStatus executionStatus) {
        this.executionStatus = executionStatus;
    }

    public void setChainId(String chainId) {
        this.chainId = chainId;
    }

    public void setChainName(String chainName) {
        this.chainName = chainName;
    }

    public void setEngineAddress(String engineAddress) {
        this.engineAddress = engineAddress;
    }

    public void setLoggingLevel(String loggingLevel) {
        this.loggingLevel = loggingLevel;
    }

    public void setSnapshotName(String snapshotName) {
        this.snapshotName = snapshotName;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public void setCheckpoints(List<CheckpointDTO> checkpoints) {
        this.checkpoints = checkpoints;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CheckpointSessionDTO)) {
            return false;
        }
        CheckpointSessionDTO other = (CheckpointSessionDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$duration = this.getDuration();
        Long other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$started = this.getStarted();
        String other$started = other.getStarted();
        if (this$started == null ? other$started != null : !this$started.equals(other$started)) {
            return false;
        }
        String this$finished = this.getFinished();
        String other$finished = other.getFinished();
        if (this$finished == null ? other$finished != null : !this$finished.equals(other$finished)) {
            return false;
        }
        ExecutionStatus this$executionStatus = this.getExecutionStatus();
        ExecutionStatus other$executionStatus = other.getExecutionStatus();
        if (this$executionStatus == null ? other$executionStatus != null : !((Object)((Object)this$executionStatus)).equals((Object)other$executionStatus)) {
            return false;
        }
        String this$chainId = this.getChainId();
        String other$chainId = other.getChainId();
        if (this$chainId == null ? other$chainId != null : !this$chainId.equals(other$chainId)) {
            return false;
        }
        String this$chainName = this.getChainName();
        String other$chainName = other.getChainName();
        if (this$chainName == null ? other$chainName != null : !this$chainName.equals(other$chainName)) {
            return false;
        }
        String this$engineAddress = this.getEngineAddress();
        String other$engineAddress = other.getEngineAddress();
        if (this$engineAddress == null ? other$engineAddress != null : !this$engineAddress.equals(other$engineAddress)) {
            return false;
        }
        String this$loggingLevel = this.getLoggingLevel();
        String other$loggingLevel = other.getLoggingLevel();
        if (this$loggingLevel == null ? other$loggingLevel != null : !this$loggingLevel.equals(other$loggingLevel)) {
            return false;
        }
        String this$snapshotName = this.getSnapshotName();
        String other$snapshotName = other.getSnapshotName();
        if (this$snapshotName == null ? other$snapshotName != null : !this$snapshotName.equals(other$snapshotName)) {
            return false;
        }
        String this$correlationId = this.getCorrelationId();
        String other$correlationId = other.getCorrelationId();
        if (this$correlationId == null ? other$correlationId != null : !this$correlationId.equals(other$correlationId)) {
            return false;
        }
        List<CheckpointDTO> this$checkpoints = this.getCheckpoints();
        List<CheckpointDTO> other$checkpoints = other.getCheckpoints();
        return !(this$checkpoints == null ? other$checkpoints != null : !((Object)this$checkpoints).equals(other$checkpoints));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CheckpointSessionDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $started = this.getStarted();
        result = result * 59 + ($started == null ? 43 : $started.hashCode());
        String $finished = this.getFinished();
        result = result * 59 + ($finished == null ? 43 : $finished.hashCode());
        ExecutionStatus $executionStatus = this.getExecutionStatus();
        result = result * 59 + ($executionStatus == null ? 43 : ((Object)((Object)$executionStatus)).hashCode());
        String $chainId = this.getChainId();
        result = result * 59 + ($chainId == null ? 43 : $chainId.hashCode());
        String $chainName = this.getChainName();
        result = result * 59 + ($chainName == null ? 43 : $chainName.hashCode());
        String $engineAddress = this.getEngineAddress();
        result = result * 59 + ($engineAddress == null ? 43 : $engineAddress.hashCode());
        String $loggingLevel = this.getLoggingLevel();
        result = result * 59 + ($loggingLevel == null ? 43 : $loggingLevel.hashCode());
        String $snapshotName = this.getSnapshotName();
        result = result * 59 + ($snapshotName == null ? 43 : $snapshotName.hashCode());
        String $correlationId = this.getCorrelationId();
        result = result * 59 + ($correlationId == null ? 43 : $correlationId.hashCode());
        List<CheckpointDTO> $checkpoints = this.getCheckpoints();
        result = result * 59 + ($checkpoints == null ? 43 : ((Object)$checkpoints).hashCode());
        return result;
    }

    public String toString() {
        return "CheckpointSessionDTO(id=" + this.getId() + ", started=" + this.getStarted() + ", finished=" + this.getFinished() + ", duration=" + this.getDuration() + ", executionStatus=" + String.valueOf((Object)this.getExecutionStatus()) + ", chainId=" + this.getChainId() + ", chainName=" + this.getChainName() + ", engineAddress=" + this.getEngineAddress() + ", loggingLevel=" + this.getLoggingLevel() + ", snapshotName=" + this.getSnapshotName() + ", correlationId=" + this.getCorrelationId() + ", checkpoints=" + String.valueOf(this.getCheckpoints()) + ")";
    }

    public static class CheckpointSessionDTOBuilder {
        private String id;
        private String started;
        private String finished;
        private Long duration;
        private ExecutionStatus executionStatus;
        private String chainId;
        private String chainName;
        private String engineAddress;
        private String loggingLevel;
        private String snapshotName;
        private String correlationId;
        private List<CheckpointDTO> checkpoints;

        CheckpointSessionDTOBuilder() {
        }

        public CheckpointSessionDTOBuilder id(String id) {
            this.id = id;
            return this;
        }

        public CheckpointSessionDTOBuilder started(String started) {
            this.started = started;
            return this;
        }

        public CheckpointSessionDTOBuilder finished(String finished) {
            this.finished = finished;
            return this;
        }

        public CheckpointSessionDTOBuilder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        public CheckpointSessionDTOBuilder executionStatus(ExecutionStatus executionStatus) {
            this.executionStatus = executionStatus;
            return this;
        }

        public CheckpointSessionDTOBuilder chainId(String chainId) {
            this.chainId = chainId;
            return this;
        }

        public CheckpointSessionDTOBuilder chainName(String chainName) {
            this.chainName = chainName;
            return this;
        }

        public CheckpointSessionDTOBuilder engineAddress(String engineAddress) {
            this.engineAddress = engineAddress;
            return this;
        }

        public CheckpointSessionDTOBuilder loggingLevel(String loggingLevel) {
            this.loggingLevel = loggingLevel;
            return this;
        }

        public CheckpointSessionDTOBuilder snapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        public CheckpointSessionDTOBuilder correlationId(String correlationId) {
            this.correlationId = correlationId;
            return this;
        }

        public CheckpointSessionDTOBuilder checkpoints(List<CheckpointDTO> checkpoints) {
            this.checkpoints = checkpoints;
            return this;
        }

        public CheckpointSessionDTO build() {
            return new CheckpointSessionDTO(this.id, this.started, this.finished, this.duration, this.executionStatus, this.chainId, this.chainName, this.engineAddress, this.loggingLevel, this.snapshotName, this.correlationId, this.checkpoints);
        }

        public String toString() {
            return "CheckpointSessionDTO.CheckpointSessionDTOBuilder(id=" + this.id + ", started=" + this.started + ", finished=" + this.finished + ", duration=" + this.duration + ", executionStatus=" + String.valueOf((Object)this.executionStatus) + ", chainId=" + this.chainId + ", chainName=" + this.chainName + ", engineAddress=" + this.engineAddress + ", loggingLevel=" + this.loggingLevel + ", snapshotName=" + this.snapshotName + ", correlationId=" + this.correlationId + ", checkpoints=" + String.valueOf(this.checkpoints) + ")";
        }
    }
}

