/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service.debugger.tracing;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.tracing.ActiveSpanManager;
import org.apache.camel.tracing.SpanAdapter;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.engine.configuration.TracingConfiguration;
import org.qubership.integration.platform.engine.model.deployment.properties.CamelDebuggerProperties;
import org.qubership.integration.platform.engine.service.debugger.tracing.MicrometerObservationTaggedTracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class TracingService {
    private static final Logger log = LoggerFactory.getLogger(TracingService.class);
    public static final String X_REQUEST_ID = "X-Request-Id";
    private final TracingConfiguration tracingConfiguration;

    @Autowired
    public TracingService(TracingConfiguration tracingConfiguration) {
        this.tracingConfiguration = tracingConfiguration;
    }

    public boolean isTracingEnabled() {
        return this.tracingConfiguration.isTracingEnabled();
    }

    public void addElementTracingTags(Exchange exchange, String nodeId, CamelDebuggerProperties dbgProperties) {
        if (dbgProperties.containsElementProperty(nodeId)) {
            HashMap<String, String> customTags = new HashMap<String, String>();
            customTags.put("elementName", (String)dbgProperties.getElementProperty(nodeId).get("elementName"));
            customTags.put("elementType", (String)dbgProperties.getElementProperty(nodeId).get("elementType"));
            TracingService.setXRequestTag(customTags);
            this.addTracingTagsToProperties(exchange, customTags);
            SpanAdapter spanAdapter = ActiveSpanManager.getSpan((Exchange)exchange);
            if (spanAdapter != null) {
                MicrometerObservationTaggedTracer.insertCustomTagsToSpan((Exchange)exchange, (SpanAdapter)spanAdapter);
            }
        }
    }

    public void addChainTracingTags(Exchange exchange, CamelDebuggerProperties dbgProperties) {
        HashMap<String, String> customTags = new HashMap<String, String>();
        customTags.put("internalProperty_sessionId", exchange.getProperty("internalProperty_sessionId").toString());
        customTags.put("chainId", dbgProperties.getDeploymentInfo().getChainId());
        customTags.put("chainName", dbgProperties.getDeploymentInfo().getChainName());
        TracingService.setXRequestTag(customTags);
        this.addTracingTagsToProperties(exchange, customTags);
    }

    private static void setXRequestTag(Map<String, String> customTags) {
        String xRequestId = MDC.get((String)"X-Request-ID");
        if (!StringUtils.isEmpty((CharSequence)xRequestId)) {
            customTags.put("X-Request-Id", xRequestId);
        }
    }

    private void addTracingTagsToProperties(Exchange exchange, Map<String, String> customTags) {
        Map tags = exchange.getProperties().getOrDefault("internalProperty_tracingCustomTags", new HashMap());
        tags.putAll(customTags);
        exchange.setProperty("internalProperty_tracingCustomTags", (Object)tags);
    }
}

