/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service.externallibrary;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.engine.events.ExternalLibrariesUpdatedEvent;
import org.qubership.integration.platform.engine.model.kafka.systemmodel.CompiledLibraryUpdate;
import org.qubership.integration.platform.engine.service.externallibrary.ExternalLibraryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
@ConditionalOnMissingBean(value={ExternalLibraryService.class})
public class DefaultExternalLibraryService
implements ExternalLibraryService {
    private static final Logger log = LoggerFactory.getLogger(DefaultExternalLibraryService.class);
    private static final String RUNTIME_CATALOG_DOWNLOAD_DTO_JAR_ENDPOINT_TEMPLATE = "/v1/models/{id}/dto/jar";
    private static final String LIBRARIES_PATH = "/tmp/cip-engine-libraries";
    @Value(value="${cip.internal-services.runtime-catalog.url}")
    private String runtimeCatalogUrl;
    private final RestTemplate restTemplateMS;
    private final List<Supplier<Collection<Path>>> librarySuppliers;
    private final ApplicationEventPublisher applicationEventPublisher;
    private volatile ClassLoader shellClassLoader;
    private volatile Collection<CompiledLibraryUpdate> systemModelLibraries;

    @Autowired
    public DefaultExternalLibraryService(RestTemplate restTemplateMS, List<Supplier<Collection<Path>>> librarySuppliers, ApplicationEventPublisher applicationEventPublisher) {
        this.restTemplateMS = restTemplateMS;
        this.librarySuppliers = librarySuppliers;
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public synchronized ClassLoader getShellClassLoader() {
        return Objects.isNull(this.shellClassLoader) ? this.getClass().getClassLoader() : this.shellClassLoader;
    }

    public synchronized void updateSystemModelLibraries(List<CompiledLibraryUpdate> compiledLibraryUpdates) {
        HashSet presentLibraries = new HashSet(Objects.isNull(this.systemModelLibraries) ? Collections.emptySet() : this.systemModelLibraries);
        HashSet<CompiledLibraryUpdate> librariesToAdd = new HashSet<CompiledLibraryUpdate>(compiledLibraryUpdates);
        librariesToAdd.removeAll(presentLibraries);
        HashSet librariesToRemove = new HashSet(Objects.isNull(this.systemModelLibraries) ? Collections.emptySet() : this.systemModelLibraries);
        compiledLibraryUpdates.forEach(librariesToRemove::remove);
        ((Stream)librariesToRemove.stream().parallel()).map(CompiledLibraryUpdate::getModelId).map(arg_0 -> this.getSystemModelLibraryPath(arg_0)).forEach(arg_0 -> this.removeLibrary(arg_0));
        ((Stream)librariesToAdd.stream().parallel()).forEach(model -> this.loadSystemModelLibrary(model, this.getSystemModelLibraryPath(model.getModelId())));
        boolean initialUpdate = Objects.isNull(this.systemModelLibraries);
        boolean hasUpdates = !librariesToAdd.isEmpty() || !librariesToRemove.isEmpty();
        this.systemModelLibraries = compiledLibraryUpdates;
        if (hasUpdates) {
            this.updateShellClassLoader();
        }
        if (hasUpdates || initialUpdate) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new ExternalLibrariesUpdatedEvent((Object)this, initialUpdate));
        }
    }

    public synchronized ClassLoader getClassLoaderForSystemModels(Collection<String> systemModelIds, ClassLoader parentClassLoader) {
        HashSet<String> ids = new HashSet<String>(systemModelIds);
        List<URL> urls = this.systemModelLibraries.stream().map(CompiledLibraryUpdate::getModelId).filter(ids::contains).map(arg_0 -> this.getSystemModelLibraryPath(arg_0)).map(arg_0 -> this.toUrl(arg_0)).filter(Objects::nonNull).toList();
        return urls.isEmpty() ? parentClassLoader : new URLClassLoader(urls.toArray(new URL[0]), parentClassLoader);
    }

    private void removeLibrary(Path path) {
        try {
            if (Files.deleteIfExists(path)) {
                log.debug("Removed library: {}", (Object)path);
            }
        }
        catch (IOException exception) {
            log.warn("Failed to remove library {}: {}", (Object)path, (Object)exception.getMessage());
        }
    }

    private Path getSystemModelLibraryPath(String modelId) {
        return this.buildLibraryPath(modelId + ".jar");
    }

    private void loadSystemModelLibrary(CompiledLibraryUpdate model, Path path) {
        try {
            log.debug("Requesting DTO classes library for system model {}", (Object)model.getModelId());
            String url = this.getSystemModelDtoLibraryDownloadUrl();
            ResponseEntity response = this.restTemplateMS.getForEntity(url, Resource.class, new Object[]{model.getModelId()});
            if (response.hasBody() && ((Resource)response.getBody()).contentLength() > 0L) {
                this.saveLibrary(((Resource)response.getBody()).getInputStream(), path);
            } else {
                log.debug("System model doesn't have DTO classes library: {}", (Object)model.getModelId());
            }
        }
        catch (IOException | RestClientException exception) {
            log.error("Failed to load DTO classes library for system model {}: {}", (Object)model.getModelId(), (Object)exception.getMessage());
        }
    }

    private String getSystemModelDtoLibraryDownloadUrl() {
        return this.runtimeCatalogUrl + RUNTIME_CATALOG_DOWNLOAD_DTO_JAR_ENDPOINT_TEMPLATE;
    }

    private void updateShellClassLoader() {
        List systemModelLibraryPaths = Collections.emptyList();
        if (this.systemModelLibraries != null) {
            systemModelLibraryPaths = this.systemModelLibraries.stream().map(CompiledLibraryUpdate::getModelId).map(arg_0 -> this.getSystemModelLibraryPath(arg_0)).collect(Collectors.toList());
        }
        List<URL> libraryUrls = Stream.concat(this.librarySuppliers.stream().map(Supplier::get), Stream.of(systemModelLibraryPaths)).filter(Objects::nonNull).flatMap(Collection::stream).map(arg_0 -> this.toUrl(arg_0)).filter(Objects::nonNull).toList();
        ClassLoader classLoader = this.getClass().getClassLoader();
        this.shellClassLoader = libraryUrls.isEmpty() ? classLoader : new URLClassLoader(libraryUrls.toArray(new URL[0]), classLoader);
    }

    private Path buildLibraryPath(String filePath) {
        Path root = Paths.get(LIBRARIES_PATH, new String[0]);
        String fileName = FilenameUtils.getName((String)filePath);
        if (StringUtils.isBlank((CharSequence)fileName)) {
            fileName = this.generateRandomFileName();
        }
        return root.resolve(fileName);
    }

    private boolean saveLibrary(InputStream libraryData, Path path) {
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.copy(libraryData, path, StandardCopyOption.REPLACE_EXISTING);
            log.debug("Saved library: {}", (Object)path);
            return true;
        }
        catch (IOException exception) {
            log.error("Failed to save library {}: {}", (Object)path, (Object)exception.getMessage());
            return false;
        }
    }

    private String generateRandomFileName() {
        return UUID.randomUUID().toString();
    }

    private URL toUrl(Path path) {
        try {
            return path.toUri().toURL();
        }
        catch (MalformedURLException exception) {
            log.error("Failed to get URL for library {}: {}", (Object)path, (Object)exception.getMessage());
            return null;
        }
    }
}

