package org.qubership.integration.platform.engine.rest.v1.mapper;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.annotation.processing.Generated;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.qubership.integration.platform.engine.persistence.shared.entity.SessionInfo;
import org.qubership.integration.platform.engine.rest.v1.dto.checkpoint.CheckpointSessionDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2025-10-22T15:05:41+0000",
    comments = "version: 1.5.5.Final, compiler: javac, environment: Java 21.0.8 (Eclipse Adoptium)"
)
@Component
public class SessionInfoMapperImpl implements SessionInfoMapper {

    @Autowired
    private CheckpointMapper checkpointMapper;
    private final DatatypeFactory datatypeFactory;

    public SessionInfoMapperImpl() {
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch ( DatatypeConfigurationException ex ) {
            throw new RuntimeException( ex );
        }
    }

    @Override
    public CheckpointSessionDTO asDTO(SessionInfo sessionInfo) {
        if ( sessionInfo == null ) {
            return null;
        }

        CheckpointSessionDTO.CheckpointSessionDTOBuilder checkpointSessionDTO = CheckpointSessionDTO.builder();

        checkpointSessionDTO.id( sessionInfo.getId() );
        checkpointSessionDTO.started( xmlGregorianCalendarToString( dateToXmlGregorianCalendar( sessionInfo.getStarted() ), null ) );
        checkpointSessionDTO.finished( xmlGregorianCalendarToString( dateToXmlGregorianCalendar( sessionInfo.getFinished() ), null ) );
        checkpointSessionDTO.duration( sessionInfo.getDuration() );
        checkpointSessionDTO.executionStatus( sessionInfo.getExecutionStatus() );
        checkpointSessionDTO.chainId( sessionInfo.getChainId() );
        checkpointSessionDTO.chainName( sessionInfo.getChainName() );
        checkpointSessionDTO.engineAddress( sessionInfo.getEngineAddress() );
        checkpointSessionDTO.loggingLevel( sessionInfo.getLoggingLevel() );
        checkpointSessionDTO.snapshotName( sessionInfo.getSnapshotName() );
        checkpointSessionDTO.correlationId( sessionInfo.getCorrelationId() );
        checkpointSessionDTO.checkpoints( checkpointMapper.asDTO( sessionInfo.getCheckpoints() ) );

        return checkpointSessionDTO.build();
    }

    @Override
    public List<CheckpointSessionDTO> asDTO(List<SessionInfo> sessionInfo) {
        if ( sessionInfo == null ) {
            return null;
        }

        List<CheckpointSessionDTO> list = new ArrayList<CheckpointSessionDTO>( sessionInfo.size() );
        for ( SessionInfo sessionInfo1 : sessionInfo ) {
            list.add( asDTO( sessionInfo1 ) );
        }

        return list;
    }

    private String xmlGregorianCalendarToString( XMLGregorianCalendar xcal, String dateFormat ) {
        if ( xcal == null ) {
            return null;
        }

        if (dateFormat == null ) {
            return xcal.toString();
        }
        else {
            Date d = xcal.toGregorianCalendar().getTime();
            SimpleDateFormat sdf = new SimpleDateFormat( dateFormat );
            return sdf.format( d );
        }
    }

    private XMLGregorianCalendar dateToXmlGregorianCalendar( Date date ) {
        if ( date == null ) {
            return null;
        }

        GregorianCalendar c = new GregorianCalendar();
        c.setTime( date );
        return datatypeFactory.newXMLGregorianCalendar( c );
    }
}
