/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.components.graphql;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.component.graphql.GraphqlEndpoint;
import org.apache.camel.component.graphql.GraphqlProducer;
import org.apache.camel.http.base.HttpOperationFailedException;
import org.apache.camel.util.json.JsonObject;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicHeader;

public class GraphqlCustomProducer
extends GraphqlProducer {
    private static final Set<String> EXCLUDE_HEADERS = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);

    public GraphqlCustomProducer(GraphqlEndpoint endpoint) {
        super(endpoint);
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            Map exchangeHeaders = exchange.getMessage().getHeaders();
            CloseableHttpClient httpClient = this.getEndpoint().getHttpclient();
            URI httpUri = this.getEndpoint().getHttpUri();
            String requestBody = GraphqlCustomProducer.buildRequestBody((String)this.getQuery(exchange), (String)this.getEndpoint().getOperationName(), (JsonObject)this.getVariables(exchange));
            StringEntity requestEntity = new StringEntity(requestBody, ContentType.create((String)"application/json", (String)"UTF-8"));
            HttpPost httpPost = new HttpPost(httpUri);
            httpPost.setHeaders(GraphqlCustomProducer.convertHeaders(exchangeHeaders));
            httpPost.setHeader("Accept", (Object)"application/json");
            httpPost.setHeader("Accept-Encoding", (Object)"gzip");
            httpPost.setEntity((HttpEntity)requestEntity);
            CloseableHttpResponse response = httpClient.execute((ClassicHttpRequest)httpPost);
            int statusCode = response.getCode();
            exchange.getMessage().setHeader("CamelHttpResponseCode", (Object)statusCode);
            String responseContent = response.getEntity() == null ? null : EntityUtils.toString((HttpEntity)response.getEntity());
            Map<String, String> headers = GraphqlCustomProducer.convertHeaders(response.getHeaders());
            if (statusCode >= 400 && statusCode <= 599) {
                String statusText = response.getReasonPhrase();
                throw new HttpOperationFailedException(httpUri.toString(), statusCode, statusText, null, headers, responseContent);
            }
            exchange.getMessage().setBody((Object)responseContent);
            exchange.getMessage().getHeaders().putAll(headers);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        callback.done(true);
        return true;
    }

    private static Map<String, String> convertHeaders(Header[] responseHeaders) {
        if (responseHeaders == null || responseHeaders.length == 0) {
            return Collections.emptyMap();
        }
        return Arrays.stream(responseHeaders).collect(Collectors.toMap(NameValuePair::getName, NameValuePair::getValue, (a, b) -> b));
    }

    private static Header[] convertHeaders(Map<String, Object> requestHeaders) {
        if (requestHeaders == null || requestHeaders.isEmpty()) {
            return new Header[0];
        }
        return (Header[])requestHeaders.entrySet().stream().filter(entry -> entry.getValue() instanceof String && !EXCLUDE_HEADERS.contains(entry.getKey())).map(entry -> new BasicHeader((String)entry.getKey(), entry.getValue())).toArray(Header[]::new);
    }

    private String getQuery(Exchange exchange) throws InvalidPayloadException {
        String query = null;
        query = this.getEndpoint().getQuery() != null ? this.getEndpoint().getQuery() : (this.getEndpoint().getQueryHeader() != null ? (String)exchange.getIn().getHeader(this.getEndpoint().getQueryHeader(), String.class) : (String)exchange.getIn().getMandatoryBody(String.class));
        return query;
    }

    private JsonObject getVariables(Exchange exchange) {
        JsonObject variables = null;
        if (this.getEndpoint().getVariables() != null) {
            variables = this.getEndpoint().getVariables();
        } else if (this.getEndpoint().getVariablesHeader() != null) {
            variables = (JsonObject)exchange.getIn().getHeader(this.getEndpoint().getVariablesHeader(), JsonObject.class);
        } else if (exchange.getIn().getBody() instanceof JsonObject) {
            variables = (JsonObject)exchange.getIn().getBody(JsonObject.class);
        }
        return variables;
    }

    static {
        EXCLUDE_HEADERS.addAll(Set.of("CamelGraphQLVariables", "CamelGraphQLQuery", "Content-Length"));
    }
}

