/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.processors.checkpoint;

import com.fasterxml.jackson.databind.ObjectMapper;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyRuntimeException;
import groovy.xml.XmlUtil;
import groovy.xml.slurpersupport.GPathResult;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.qubership.integration.platform.engine.camel.components.context.propagation.ContextOperationsWrapper;
import org.qubership.integration.platform.engine.model.constants.CamelConstants;
import org.qubership.integration.platform.engine.persistence.shared.entity.Checkpoint;
import org.qubership.integration.platform.engine.persistence.shared.entity.Property;
import org.qubership.integration.platform.engine.service.CheckpointSessionService;
import org.qubership.integration.platform.engine.service.debugger.util.MessageHelper;
import org.qubership.integration.platform.engine.util.ExchangeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ContextSaverProcessor
implements Processor {
    private static final Logger log = LoggerFactory.getLogger(ContextSaverProcessor.class);
    private final CheckpointSessionService checkpointSessionService;
    private final ObjectMapper checkpointMapper;
    private final Optional<ContextOperationsWrapper> contextOperations;

    @Autowired
    public ContextSaverProcessor(CheckpointSessionService checkpointSessionService, @Qualifier(value="checkpointMapper") ObjectMapper checkpointMapper, Optional<ContextOperationsWrapper> contextOperations) {
        this.checkpointSessionService = checkpointSessionService;
        this.checkpointMapper = checkpointMapper;
        this.contextOperations = contextOperations;
    }

    public void process(Exchange exchange) throws Exception {
        try {
            String body = MessageHelper.extractBody(exchange);
            Checkpoint checkpoint = Checkpoint.builder().checkpointElementId((String)exchange.getProperty("internalProperty_checkpointElementId", String.class)).headers(this.checkpointMapper.writeValueAsString(ExchangeUtils.filterExchangeMap(exchange.getMessage().getHeaders(), entry -> !CamelConstants.isInternalHeader((String)entry.getKey())))).body(body == null ? null : body.getBytes(StandardCharsets.UTF_8)).properties(this.getPropertiesForSave(ExchangeUtils.filterExchangeMap(exchange.getProperties(), entry -> !CamelConstants.isInternalProperty((String)entry.getKey())))).build();
            if (this.contextOperations.isPresent()) {
                checkpoint.setContextData(this.checkpointMapper.writeValueAsString(this.contextOperations.get().getSerializableContextData()));
            }
            this.checkpointSessionService.saveAndAssignCheckpoint(checkpoint, (String)exchange.getProperty("internalProperty_sessionId", String.class));
        }
        catch (Exception e) {
            log.error("Failed to create session checkpoint", (Throwable)e);
            throw new RuntimeException("Failed to create session checkpoint", e);
        }
    }

    List<Property> getPropertiesForSave(Map<String, Object> properties) {
        return properties.entrySet().stream().map(entry -> Property.builder().name((String)entry.getKey()).type(entry.getValue().getClass().getName()).value(this.serializeProperty(entry.getValue().getClass(), entry.getValue())).build()).collect(Collectors.toList());
    }

    byte[] serializeProperty(Class<?> propertyClass, Object property) {
        try {
            if (GPathResult.class.isAssignableFrom(propertyClass)) {
                GPathResult gpath = (GPathResult)property;
                String xml = XmlUtil.serialize((String)gpath.text());
                return xml.getBytes(StandardCharsets.UTF_8);
            }
            if (Serializable.class.isAssignableFrom(propertyClass) && !GroovyObject.class.isAssignableFrom(propertyClass)) {
                return this.serializeWithIOLibrary(property);
            }
        }
        catch (GroovyRuntimeException groovyRuntimeException) {
            GPathResult gpath = (GPathResult)property;
            return ("<value>" + XmlUtil.escapeXml((String)gpath.text()) + "</value>").getBytes(StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            return this.serializeWithObjectMapper(property);
        }
        return this.serializeWithObjectMapper(property);
    }

    byte[] serializeWithObjectMapper(Object property) {
        try {
            return this.checkpointMapper.writeValueAsBytes(property);
        }
        catch (Exception e) {
            log.error("Failed to create session checkpoint", (Throwable)e);
            throw new RuntimeException("Failed to create session checkpoint", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    byte[] serializeWithIOLibrary(Object obj) throws Exception {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream out = new ObjectOutputStream(bos);){
                out.writeObject(obj);
                out.flush();
                byArray = bos.toByteArray();
            }
            return byArray;
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
    }
}

