/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.rest.v1.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.qubership.integration.platform.engine.rest.v1.dto.checkpoint.CheckpointSessionDTO;
import org.qubership.integration.platform.engine.rest.v1.mapper.SessionInfoMapper;
import org.qubership.integration.platform.engine.service.CheckpointSessionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/engine/chains/{chainId}"}, produces={"application/json"})
@CrossOrigin(origins={"*"})
@Tag(name="checkpoint-session-controller", description="Checkpoint Session Controller")
public class CheckpointSessionController {
    private static final Logger log = LoggerFactory.getLogger(CheckpointSessionController.class);
    private final CheckpointSessionService checkpointSessionService;
    private final SessionInfoMapper sessionInfoMapper;

    @Autowired
    public CheckpointSessionController(CheckpointSessionService checkpointSessionService, SessionInfoMapper sessionInfoMapper) {
        this.checkpointSessionService = checkpointSessionService;
        this.sessionInfoMapper = sessionInfoMapper;
    }

    @PostMapping(value={"/sessions/{sessionId}/retry"})
    @Operation(description="Execute chain retry from saved latest non-failed checkpoint", extensions={@Extension(properties={@ExtensionProperty(name="x-api-kind", value="bwc")})})
    public ResponseEntity<Void> retryFromLastCheckpoint(@PathVariable @Parameter(description="Chain id") String chainId, @PathVariable @Parameter(description="Session id") String sessionId, @RequestHeader(required=false, defaultValue="") @Parameter(description="If passed, Authorization header will be replaced with this value") String authorization, @RequestHeader(required=false, defaultValue="false") @Parameter(description="Enable TraceMe header, which will force session to be logged") boolean traceMe, @RequestHeader(name="X-Idempotency-Key", required=false, defaultValue="") @Parameter(description="Idempotency header, which will be used to identify duplicate request") String xIdempotencyKey, @RequestBody(required=false) @Parameter(description="If passed, request body will be replaced with this value") String body) {
        log.info("Request to retry session {}", (Object)sessionId);
        if (StringUtils.hasText((String)xIdempotencyKey) && this.checkpointSessionService.verifyAndInsertIfNotExistIdempotencyKey(xIdempotencyKey, sessionId)) {
            log.info("Duplicate Idempotency key found, key: {}, sessionId: {}", (Object)xIdempotencyKey, (Object)sessionId);
            return ResponseEntity.accepted().build();
        }
        this.checkpointSessionService.retryFromLastCheckpoint(chainId, sessionId, body, CheckpointSessionController.toAuthSupplier(authorization), traceMe);
        return ResponseEntity.accepted().build();
    }

    @PostMapping(value={"/sessions/{sessionId}/checkpoint-elements/{checkpointElementId}/retry"})
    @Operation(description="Execute chain retry from specified non-failed checkpoint", extensions={@Extension(properties={@ExtensionProperty(name="x-api-kind", value="bwc")})})
    public ResponseEntity<Void> retryFromCheckpoint(@PathVariable @Parameter(description="Chain id") String chainId, @PathVariable @Parameter(description="Session id") String sessionId, @PathVariable @Parameter(description="Checkpoint element id (could be found on chain graph in checkpoint element itself)") String checkpointElementId, @RequestHeader(required=false, defaultValue="") @Parameter(description="If passed, Authorization header will be replaced with this value") String authorization, @RequestHeader(required=false, defaultValue="false") @Parameter(description="Enable TraceMe header, which will force session to be logged") boolean traceMe, @RequestHeader(name="X-Idempotency-Key", required=false, defaultValue="") @Parameter(description="Idempotency header, which will be used to identify duplicate request") String xIdempotencyKey, @RequestBody(required=false) @Parameter(description="If passed, request body will be replaced with this value") String body) {
        log.info("Request to retry session {} from checkpoint {}", (Object)sessionId, (Object)checkpointElementId);
        if (StringUtils.hasText((String)xIdempotencyKey) && this.checkpointSessionService.verifyAndInsertIfNotExistIdempotencyKey(xIdempotencyKey, sessionId)) {
            log.info("Duplicate Idempotency key found, key: {}, sessionId: {}", (Object)xIdempotencyKey, (Object)sessionId);
            return ResponseEntity.accepted().build();
        }
        this.checkpointSessionService.retryFromCheckpoint(chainId, sessionId, checkpointElementId, body, CheckpointSessionController.toAuthSupplier(authorization), traceMe);
        return ResponseEntity.accepted().build();
    }

    @Transactional(value="checkpointTransactionManager")
    @GetMapping(value={"/sessions/failed"})
    @Operation(description="List all failed sessions with available checkpoints for specified chain", extensions={@Extension(properties={@ExtensionProperty(name="x-api-kind", value="bwc")})})
    public ResponseEntity<List<CheckpointSessionDTO>> getFailedChainSessionsInfo(@PathVariable @Parameter(description="Chain id") String chainId) {
        return ResponseEntity.ok(this.sessionInfoMapper.asDTO(this.checkpointSessionService.findAllFailedChainSessionsInfo(chainId)));
    }

    @NotNull
    private static Supplier<Pair<String, String>> toAuthSupplier(String authorization) {
        return () -> Pair.of((Object)"Authorization", (Object)authorization);
    }
}

