/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.persistence.EntityNotFoundException;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.integration.platform.engine.model.checkpoint.CheckpointPayloadOptions;
import org.qubership.integration.platform.engine.persistence.shared.entity.Checkpoint;
import org.qubership.integration.platform.engine.persistence.shared.entity.SessionInfo;
import org.qubership.integration.platform.engine.persistence.shared.repository.CheckpointRepository;
import org.qubership.integration.platform.engine.persistence.shared.repository.SessionInfoRepository;
import org.qubership.integration.platform.engine.service.ExecutionStatus;
import org.qubership.integration.platform.engine.service.IdempotencyRecordService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.reactive.function.client.WebClient;

@Component
public class CheckpointSessionService {
    private static final Logger log = LoggerFactory.getLogger(CheckpointSessionService.class);
    private final SessionInfoRepository sessionInfoRepository;
    private final CheckpointRepository checkpointRepository;
    private final WebClient localhostWebclient;
    private final ObjectMapper jsonMapper;
    private final IdempotencyRecordService idempotencyRecordService;
    @Value(value="${qip.sessions.checkpoints.cleanup.interval}")
    private String idempotencyKeyTTL;

    @Autowired
    public CheckpointSessionService(SessionInfoRepository sessionInfoRepository, CheckpointRepository checkpointRepository, WebClient localhostWebclient, @Qualifier(value="jsonMapper") ObjectMapper jsonMapper, IdempotencyRecordService idempotencyRecordService) {
        this.sessionInfoRepository = sessionInfoRepository;
        this.checkpointRepository = checkpointRepository;
        this.localhostWebclient = localhostWebclient;
        this.jsonMapper = jsonMapper;
        this.idempotencyRecordService = idempotencyRecordService;
    }

    @Transactional(value="checkpointTransactionManager")
    public void retryFromLastCheckpoint(String chainId, String sessionId, String body, Supplier<Pair<String, String>> authHeaderProvider, boolean traceMe) {
        Checkpoint lastCheckpoint = this.findLastCheckpoint(chainId, sessionId);
        if (lastCheckpoint == null) {
            throw new EntityNotFoundException("Can't find checkpoint for session with id: " + sessionId);
        }
        this.retryFromCheckpointAsync(lastCheckpoint, body, authHeaderProvider, traceMe);
    }

    @Transactional(value="checkpointTransactionManager")
    public void retryFromCheckpoint(String chainId, String sessionId, String checkpointElementId, String body, Supplier<Pair<String, String>> authHeaderProvider, boolean traceMe) {
        Checkpoint checkpoint = this.checkpointRepository.findFirstBySessionIdAndSessionChainIdAndCheckpointElementId(sessionId, chainId, checkpointElementId);
        if (checkpoint == null) {
            throw new EntityNotFoundException("Can't find checkpoint " + checkpointElementId + " for session with id: " + sessionId);
        }
        this.retryFromCheckpointAsync(checkpoint, body, authHeaderProvider, traceMe);
    }

    private void retryFromCheckpointAsync(Checkpoint checkpoint, String body, Supplier<Pair<String, String>> authHeaderProvider, boolean traceMe) {
        WebClient.RequestBodySpec request = (WebClient.RequestBodySpec)this.localhostWebclient.post().uri("/routes/chains/{checkpointChainId}/sessions/{checkpointSessionId}/checkpoint-elements/{checkpointElementId}/retry", new Object[]{checkpoint.getSession().getChainId(), checkpoint.getSession().getId(), checkpoint.getCheckpointElementId()});
        Pair<String, String> authPair = authHeaderProvider.get();
        if (authPair != null) {
            request.header((String)authPair.getKey(), new String[]{(String)authPair.getValue()});
        }
        request.header("TraceMe", new String[]{String.valueOf(traceMe)});
        request.contentType(MediaType.APPLICATION_JSON);
        if (StringUtils.isNotEmpty((CharSequence)body)) {
            this.validateRetryBody(body);
            request.bodyValue((Object)body);
        }
        request.retrieve().toBodilessEntity().subscribe();
    }

    private void validateRetryBody(String body) {
        try {
            this.jsonMapper.readValue(body, CheckpointPayloadOptions.class);
        }
        catch (Exception e) {
            log.error("Failed to parse checkpoint options from retry request", (Throwable)e);
            throw new RuntimeException("Failed to parse checkpoint options from retry request", e);
        }
    }

    @Transactional(value="checkpointTransactionManager")
    public Checkpoint findLastCheckpoint(String chainId, String sessionId) {
        List<Checkpoint> checkpoints = this.checkpointRepository.findAllBySessionChainIdAndSessionId(chainId, sessionId, (Pageable)PageRequest.of((int)0, (int)1, (Sort)Sort.by((String[])new String[]{"timestamp"}).descending()));
        return checkpoints == null || checkpoints.isEmpty() ? null : checkpoints.get(0);
    }

    @Transactional(value="checkpointTransactionManager")
    public List<SessionInfo> findAllFailedChainSessionsInfo(String chainId) {
        List<SessionInfo> allByChainIdAndExecutionStatus = this.sessionInfoRepository.findAllByChainIdAndExecutionStatus(chainId, ExecutionStatus.COMPLETED_WITH_ERRORS);
        return allByChainIdAndExecutionStatus;
    }

    @Transactional(value="checkpointTransactionManager")
    public SessionInfo saveSession(SessionInfo sessionInfo) {
        return (SessionInfo)this.sessionInfoRepository.save(sessionInfo);
    }

    @Transactional(value="checkpointTransactionManager")
    public void saveAndAssignCheckpoint(Checkpoint checkpoint, String sessionId) {
        SessionInfo sessionInfo = this.findSession(sessionId);
        if (sessionInfo == null) {
            throw new EntityNotFoundException("Failed to assign checkpoint to session with id " + sessionId);
        }
        checkpoint.assignProperties(checkpoint.getProperties());
        sessionInfo.assignCheckpoint(checkpoint);
    }

    @Transactional(value="checkpointTransactionManager")
    public Checkpoint findCheckpoint(String sessionId, String chainId, String checkpointElementId) {
        return this.checkpointRepository.findFirstBySessionIdAndSessionChainIdAndCheckpointElementId(sessionId, chainId, checkpointElementId);
    }

    @Transactional(value="checkpointTransactionManager")
    public SessionInfo findSession(String sessionId) {
        return this.sessionInfoRepository.findById(sessionId).orElse(null);
    }

    @Transactional(value="checkpointTransactionManager")
    public List<SessionInfo> findSessions(List<String> sessionIds) {
        return this.sessionInfoRepository.findAllById(sessionIds);
    }

    @Transactional(value="checkpointTransactionManager")
    public void updateSessionParent(String sessionId, String parentId) {
        SessionInfo sessionInfo = (SessionInfo)this.sessionInfoRepository.findById(sessionId).orElseThrow(EntityNotFoundException::new);
        SessionInfo parentSessionInfo = (SessionInfo)this.sessionInfoRepository.findById(parentId).orElseThrow(EntityNotFoundException::new);
        sessionInfo.setParentSession(parentSessionInfo);
    }

    @Transactional(value="checkpointTransactionManager")
    public Optional<SessionInfo> findOriginalSessionInfo(String sessionId) {
        return this.sessionInfoRepository.findOriginalSessionInfo(sessionId);
    }

    @Transactional(value="checkpointTransactionManager")
    public void removeAllRelatedCheckpoints(String sessionId, boolean isRootSession) {
        if (isRootSession) {
            this.sessionInfoRepository.deleteById(sessionId);
        } else {
            this.sessionInfoRepository.deleteAllRelatedSessionsAndCheckpoints(sessionId);
        }
    }

    @Transactional(value="checkpointTransactionManager")
    public void deleteOldRecordsByInterval(String checkpointsInterval) {
        this.sessionInfoRepository.deleteOldRecordsByInterval(checkpointsInterval);
    }

    @Transactional(value="checkpointTransactionManager")
    public boolean verifyAndInsertIfNotExistIdempotencyKey(String xIdempotencyKey, String sessionId) {
        String uniqueIdempotencyKey = this.getUniqueKeyForIdempotency(xIdempotencyKey, sessionId);
        boolean idempotencyKeyExists = this.idempotencyRecordService.exists(uniqueIdempotencyKey);
        if (!idempotencyKeyExists) {
            log.info("Idempotency key does not exist or expired, inserting or updating the key: {}, sessionId: {}", (Object)uniqueIdempotencyKey, (Object)sessionId);
            this.idempotencyRecordService.insertIfNotExists(uniqueIdempotencyKey, this.idempotencyKeyTTL);
            return false;
        }
        log.info("Idempotency key exists and not expired, key: {}, sessionId: {}", (Object)uniqueIdempotencyKey, (Object)sessionId);
        return true;
    }

    public String getUniqueKeyForIdempotency(String xIdempotencyKey, String sessionId) {
        String prefix = "session-retries";
        String separator = ":";
        return String.join((CharSequence)separator, prefix, sessionId, xIdempotencyKey);
    }
}

