/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service.contextstorage;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.qubership.integration.platform.engine.errorhandling.ContextStorageException;
import org.qubership.integration.platform.engine.persistence.shared.entity.ContextSystemRecords;
import org.qubership.integration.platform.engine.persistence.shared.repository.ContextStorageRespository;
import org.qubership.integration.platform.engine.service.contextstorage.ContextData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ContextStorageService {
    private static final Logger log = LoggerFactory.getLogger(ContextStorageService.class);
    private static final String CONTEXT = "context";
    private final ContextStorageRespository contextStorageRepository;
    private final ObjectMapper objectMapper;

    @Autowired
    public ContextStorageService(ContextStorageRespository contextStorageRepository, ObjectMapper objectMapper) {
        this.contextStorageRepository = contextStorageRepository;
        this.objectMapper = objectMapper;
    }

    public void storeValue(String contextKey, String contextValue, String contextServiceId, String contextId, long ttl) {
        Optional<ContextSystemRecords> oldRecord = this.contextStorageRepository.findByContextServiceIdAndContextId(contextServiceId, contextId);
        ContextData existingContext = this.contextKeyExits(contextKey, contextValue, contextServiceId, contextId);
        ContextSystemRecords contextSystemRecords = ContextSystemRecords.builder().id(oldRecord.isPresent() ? oldRecord.get().getId() : UUID.randomUUID().toString()).value((JsonNode)this.objectMapper.convertValue((Object)existingContext, JsonNode.class)).contextServiceId(contextServiceId).contextId(contextId).createdAt(oldRecord.isPresent() ? oldRecord.get().getCreatedAt() : Timestamp.from(Instant.now())).expiresAt(Timestamp.from(Instant.now().plusSeconds(ttl))).updatedAt(Timestamp.from(Instant.now())).build();
        this.contextStorageRepository.save(contextSystemRecords);
        log.debug("Value stored successfully for contextKey: {}, contextServiceId: {}, contextId: {}", new Object[]{contextKey, contextServiceId, contextId});
    }

    public Map<String, String> getValue(String contextServiceId, String contextId, List<String> keys) {
        Object jsonValue = this.contextStorageRepository.findByContextServiceIdAndContextId(contextServiceId, contextId).filter(record -> record.getExpiresAt().after(Timestamp.from(Instant.now()))).map(ContextSystemRecords::getValue).orElse(null);
        if (jsonValue != null) {
            try {
                JsonNode jsonNode = this.objectMapper.readTree(jsonValue.toString());
                JsonNode contextNode = jsonNode.get(CONTEXT);
                return keys.stream().filter(arg_0 -> ((JsonNode)contextNode).has(arg_0)).collect(Collectors.toMap(key -> key, key -> contextNode.get(key).asText()));
            }
            catch (JsonProcessingException e) {
                log.error("Error occurred while processing JSON for contextServiceId: {}, contextId: {}", new Object[]{contextServiceId, contextId, e});
                throw new RuntimeException(e);
            }
        }
        log.warn("Context keys: {}  with contextServiceId: {}, contextId: {} is either not present or expired", new Object[]{keys, contextServiceId, contextId});
        return Collections.emptyMap();
    }

    public void deleteValue(String contextServiceID, String contextId) {
        try {
            this.contextStorageRepository.deleteRecordByContextServiceIdAndContextId(contextServiceID, contextId);
            log.info("Value deleted successfully for contextServiceID: {}, contextId: {}", (Object)contextServiceID, (Object)contextId);
        }
        catch (Exception e) {
            throw new ContextStorageException("Error occurred while deleting value for contextServiceID: " + contextServiceID + " contextId: " + contextId, e);
        }
    }

    public void deleteOldRecords() {
        try {
            List<ContextSystemRecords> oldRecords = this.contextStorageRepository.findAllByExpiresAtBefore(Timestamp.from(Instant.now()));
            if (oldRecords != null && !oldRecords.isEmpty()) {
                this.contextStorageRepository.deleteAll(oldRecords);
                log.debug("Deleted old records from context storage");
            } else {
                log.debug("No old records found to delete");
            }
        }
        catch (Exception e) {
            throw new ContextStorageException("Error occurred while deleting old records from context storage", e);
        }
    }

    private ContextData contextKeyExits(String contextKey, String contextValue, String contextServiceId, String contextId) {
        try {
            return this.contextStorageRepository.findByContextServiceIdAndContextId(contextServiceId, contextId).map(existingStorage -> {
                JsonNode existingContext = existingStorage.getValue();
                HashMap<String, String> updatedContext = new HashMap<String, String>();
                if (existingContext != null) {
                    log.debug("Updating existing context for contextKey: {}", (Object)contextKey);
                    JsonNode contextNode = existingContext.get(CONTEXT);
                    contextNode.fields().forEachRemaining(entry -> updatedContext.put((String)entry.getKey(), ((String)entry.getKey()).equals(contextKey) ? contextValue : ((JsonNode)entry.getValue()).asText()));
                    updatedContext.putIfAbsent(contextKey, contextValue);
                } else {
                    log.debug("No existing context found, creating new context for contextKey: {}", (Object)contextKey);
                    updatedContext.put(contextKey, contextValue);
                }
                return ContextData.builder().context(updatedContext).build();
            }).orElseGet(() -> {
                log.debug("No existing storage found, creating new context for contextKey: {}", (Object)contextKey);
                return this.createNewContext(contextKey, contextValue);
            });
        }
        catch (Exception e) {
            throw new ContextStorageException("Error occurred while processing contextKey: " + contextKey + " contextServiceId: " + contextServiceId + " contextId: " + contextId, e);
        }
    }

    private ContextData createNewContext(String key, String value) {
        HashMap<String, String> updatedContext = new HashMap<String, String>();
        updatedContext.put(key, value);
        log.info("Creating new context with key: {} and value: {}", (Object)key, (Object)value);
        return ContextData.builder().context(updatedContext).build();
    }
}

