/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service.debugger.sessions;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.camel.Exchange;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.qubership.integration.platform.engine.model.ChainElementType;
import org.qubership.integration.platform.engine.model.Session;
import org.qubership.integration.platform.engine.model.SessionElementProperty;
import org.qubership.integration.platform.engine.model.deployment.properties.CamelDebuggerProperties;
import org.qubership.integration.platform.engine.model.logging.SessionsLoggingLevel;
import org.qubership.integration.platform.engine.model.opensearch.AbstractElementElastic;
import org.qubership.integration.platform.engine.model.opensearch.ExceptionInfo;
import org.qubership.integration.platform.engine.model.opensearch.SessionElementElastic;
import org.qubership.integration.platform.engine.service.ExecutionStatus;
import org.qubership.integration.platform.engine.service.debugger.sessions.OpenSearchWriter;
import org.qubership.integration.platform.engine.service.debugger.util.DebuggerUtils;
import org.qubership.integration.platform.engine.service.debugger.util.MaskedFieldUtils;
import org.qubership.integration.platform.engine.service.debugger.util.PayloadExtractor;
import org.qubership.integration.platform.engine.util.IdentifierUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Component
public class SessionsService {
    private static final Logger log = LoggerFactory.getLogger(SessionsService.class);
    private final PayloadExtractor extractor;
    private final OpenSearchWriter writer;
    private final Random random = new Random();
    @Value(value="${qip.sessions.sampler.probabilistic}")
    private double samplerProbabilistic;

    @Autowired
    public SessionsService(PayloadExtractor extractor, OpenSearchWriter writer) {
        this.extractor = extractor;
        this.writer = writer;
    }

    public Session startSession(Exchange exchange, CamelDebuggerProperties dbgProperties, String sessionId, String parentSessionId, String startTime, String currentDomain, String currentEngineAddress) {
        SessionsLoggingLevel sessionLevel = dbgProperties.getRuntimeProperties(exchange).calculateSessionLevel(exchange);
        Object session = ((Session.SessionBuilder)((Session.SessionBuilder)((Session.SessionBuilder)((Session.SessionBuilder)((Session.SessionBuilder)((Session.SessionBuilder)((Session.SessionBuilder)((Session.SessionBuilder)((Session.SessionBuilder)((Session.SessionBuilder)((Session.SessionBuilder)Session.builder().id(sessionId)).externalId((String)exchange.getMessage().getHeader("external-session-cip-id", String.class))).domain(currentDomain)).engineAddress(currentEngineAddress)).chainId(dbgProperties.getDeploymentInfo().getChainId())).chainName(dbgProperties.getDeploymentInfo().getChainName())).started(startTime)).executionStatus(ExecutionStatus.IN_PROGRESS)).loggingLevel(sessionLevel.toString())).snapshotName(dbgProperties.getDeploymentInfo().getSnapshotName())).parentSessionId(parentSessionId)).build();
        if (sessionLevel != SessionsLoggingLevel.OFF) {
            this.writer.putSessionToCache((Session)session);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishSession(Exchange exchange, CamelDebuggerProperties dbgProperties, ExecutionStatus executionStatus, String finishTime, long duration, long syncDuration) {
        block10: {
            String sessionId = (String)exchange.getProperty("internalProperty_sessionId", String.class);
            boolean cacheCleared = false;
            try {
                Pair<ReadWriteLock, Session> sessionPair;
                SessionsLoggingLevel sessionLevel = dbgProperties.getRuntimeProperties(exchange).calculateSessionLevel(exchange);
                if (sessionLevel == SessionsLoggingLevel.OFF || (sessionPair = this.writer.getSessionFromCache(sessionId)) == null || sessionPair.getRight() == null) break block10;
                ReadWriteLock sessionLock = (ReadWriteLock)sessionPair.getLeft();
                Session session = (Session)sessionPair.getRight();
                sessionLock.writeLock().lock();
                try {
                    if (dbgProperties.containsElementProperty("executionStatus")) {
                        executionStatus = ExecutionStatus.computeHigherPriorityStatus(ExecutionStatus.valueOf(dbgProperties.getElementProperty("executionStatus").get("executionStatus")), executionStatus);
                    }
                    session.setExecutionStatus(executionStatus);
                    session.setFinished(finishTime);
                    session.setDuration(duration);
                    session.setSyncDuration(syncDuration);
                    Collection<SessionElementElastic> elements = this.writer.getSessionElementsFromCache(sessionId);
                    for (SessionElementElastic element : elements) {
                        if (element == null) continue;
                        if (element.getExecutionStatus() == ExecutionStatus.IN_PROGRESS) {
                            element.setExecutionStatus(ExecutionStatus.CANCELLED_OR_UNKNOWN);
                        }
                        this.updateSessionInfoForElements(session, element);
                        this.writer.scheduleElementToLog(element);
                    }
                    this.writer.clearSessionCache(sessionId);
                    cacheCleared = true;
                }
                finally {
                    sessionLock.writeLock().unlock();
                }
            }
            finally {
                if (!cacheCleared) {
                    this.writer.clearSessionCache(sessionId);
                }
            }
        }
    }

    public void logSessionStepElementBefore(Exchange exchange, CamelDebuggerProperties dbgProperties, String sessionId, String sessionElementId, String stepId, String stepChainElementId) {
        SessionElementElastic sessionElement = this.buildSessionStepElementBefore(exchange, dbgProperties, sessionId, sessionElementId, stepId, stepChainElementId);
        this.writer.scheduleElementToLogAndCache(sessionElement);
    }

    @NotNull
    private SessionElementElastic buildSessionStepElementBefore(Exchange exchange, CamelDebuggerProperties dbgProperties, String sessionId, String sessionElementId, String stepId, String stepChainElementId) {
        Map<String, SessionElementProperty> propertiesForLogging = this.extractor.extractExchangePropertiesForLogging(exchange, MaskedFieldUtils.getMaskedFields(exchange.getProperty("internalProperty_maskedFields")), dbgProperties.getRuntimeProperties(exchange).isMaskingEnabled());
        Map<String, String> contextHeaders = this.extractor.extractContextForLogging(MaskedFieldUtils.getMaskedFields(exchange.getProperty("internalProperty_maskedFields")), dbgProperties.getRuntimeProperties(exchange).isMaskingEnabled());
        AbstractElementElastic sessionElement = ((SessionElementElastic.SessionElementElasticBuilder)((AbstractElementElastic.AbstractElementElasticBuilder)((SessionElementElastic.SessionElementElasticBuilder)((SessionElementElastic.SessionElementElasticBuilder)((SessionElementElastic.SessionElementElasticBuilder)((SessionElementElastic.SessionElementElasticBuilder)((AbstractElementElastic.AbstractElementElasticBuilder)((SessionElementElastic.SessionElementElasticBuilder)((SessionElementElastic.SessionElementElasticBuilder)SessionElementElastic.builder().id(sessionElementId)).elementName(stepId)).sessionId(sessionId)).started(LocalDateTime.now().toString())).bodyBefore(this.extractor.extractBodyForLogging(exchange, MaskedFieldUtils.getMaskedFields(exchange.getProperty("internalProperty_maskedFields")), dbgProperties.getRuntimeProperties(exchange).isMaskingEnabled()))).headersBefore(this.extractor.convertToJson(this.extractor.extractHeadersForLogging(exchange, MaskedFieldUtils.getMaskedFields(exchange.getProperty("internalProperty_maskedFields")), dbgProperties.getRuntimeProperties(exchange).isMaskingEnabled())))).propertiesBefore(this.extractor.convertToJson(propertiesForLogging))).contextBefore(this.extractor.convertToJson(contextHeaders))).executionStatus(ExecutionStatus.IN_PROGRESS)).build();
        Map<String, String> elementStepProperties = dbgProperties.getElementProperty(stepId);
        ((SessionElementElastic)sessionElement).setActualElementChainId(SessionsService.getActualChainId(dbgProperties, stepId, stepChainElementId));
        this.updateSessionInfoForElements(exchange, (SessionElementElastic)sessionElement);
        if (IdentifierUtils.isValidUUID(stepId)) {
            if (Objects.requireNonNull(elementStepProperties).containsKey("wireTapId")) {
                List<String> parentIds = Arrays.stream(elementStepProperties.get("wireTapId").split(",")).map(String::trim).toList();
                for (String id : parentIds) {
                    if (!((Map)exchange.getProperty("internalProperty_elementExecutionMap")).containsKey(id)) continue;
                    ((SessionElementElastic)sessionElement).setParentElementId((String)((Map)exchange.getProperty("internalProperty_elementExecutionMap")).get(id));
                }
            } else {
                ((SessionElementElastic)sessionElement).setParentElementId(this.extractParentId(exchange, sessionId, elementStepProperties));
            }
            ((SessionElementElastic)sessionElement).setChainElementId(stepId);
            ((SessionElementElastic)sessionElement).setElementName(elementStepProperties.get("elementName"));
            ((SessionElementElastic)sessionElement).setCamelElementName(elementStepProperties.get("elementType"));
        } else {
            ((SessionElementElastic)sessionElement).setParentElementId((String)((Deque)exchange.getProperty("internalProperty_steps", Deque.class)).peek());
            ((SessionElementElastic)sessionElement).setElementName(stepId);
            if (!StringUtils.isEmpty((CharSequence)stepChainElementId)) {
                ((SessionElementElastic)sessionElement).setChainElementId(stepChainElementId);
                ((SessionElementElastic)sessionElement).setCamelElementName(dbgProperties.getElementProperty(stepChainElementId).get("elementType"));
            }
        }
        return sessionElement;
    }

    private static String getActualChainId(CamelDebuggerProperties dbgProperties, String stepId, String stepChainElementId) {
        String stepNameForActualChainIdOverride;
        Map<String, String> elementStepProperties = dbgProperties.getElementProperty(stepId);
        if (elementStepProperties == null && StringUtils.isNotEmpty((CharSequence)stepChainElementId)) {
            elementStepProperties = dbgProperties.getElementProperty(stepChainElementId);
        }
        if (elementStepProperties != null && elementStepProperties.get("actualElementChainId") != null && ((stepNameForActualChainIdOverride = elementStepProperties.get("actualElementChainIdOverrideForStep")) == null || stepNameForActualChainIdOverride.equals(stepId))) {
            return elementStepProperties.get("actualElementChainId");
        }
        return null;
    }

    public void logSessionElementBefore(Exchange exchange, CamelDebuggerProperties dbgProperties, String sessionId, String sessionElementId, String nodeId, String bodyForLogging, Map<String, String> headersForLogging, Map<String, String> contextHeaders, Map<String, SessionElementProperty> exchangePropertiesForLogging) {
        SessionElementElastic sessionElement = this.buildSessionElementBefore(exchange, dbgProperties, sessionId, sessionElementId, nodeId, bodyForLogging, headersForLogging, contextHeaders, exchangePropertiesForLogging);
        this.writer.scheduleElementToLogAndCache(sessionElement);
    }

    private SessionElementElastic buildSessionElementBefore(Exchange exchange, CamelDebuggerProperties dbgProperties, String sessionId, String sessionElementId, String nodeId, String bodyForLogging, Map<String, String> headersForLogging, Map<String, String> contextHeaders, Map<String, SessionElementProperty> propertiesForLogging) {
        Map<String, String> elementProperties = dbgProperties.getElementProperty(nodeId);
        String parentElementId = this.extractParentId(exchange, sessionId, elementProperties);
        AbstractElementElastic sessionElement = ((SessionElementElastic.SessionElementElasticBuilder)((AbstractElementElastic.AbstractElementElasticBuilder)((SessionElementElastic.SessionElementElasticBuilder)((SessionElementElastic.SessionElementElasticBuilder)((SessionElementElastic.SessionElementElasticBuilder)((SessionElementElastic.SessionElementElasticBuilder)((AbstractElementElastic.AbstractElementElasticBuilder)((SessionElementElastic.SessionElementElasticBuilder)((SessionElementElastic.SessionElementElasticBuilder)((SessionElementElastic.SessionElementElasticBuilder)((SessionElementElastic.SessionElementElasticBuilder)((SessionElementElastic.SessionElementElasticBuilder)SessionElementElastic.builder().id(sessionElementId)).chainElementId(nodeId)).elementName(elementProperties.get("elementName"))).camelElementName(elementProperties.get("elementType"))).sessionId(sessionId)).parentElementId(SessionsLoggingLevel.ERROR == dbgProperties.getRuntimeProperties(exchange).calculateSessionLevel(exchange) ? null : parentElementId)).started(LocalDateTime.now().toString())).bodyBefore(bodyForLogging)).headersBefore(this.extractor.convertToJson(headersForLogging))).propertiesBefore(this.extractor.convertToJson(propertiesForLogging))).contextBefore(this.extractor.convertToJson(contextHeaders))).executionStatus(ExecutionStatus.IN_PROGRESS)).build();
        this.updateSessionInfoForElements(exchange, (SessionElementElastic)sessionElement);
        if (Objects.requireNonNull(elementProperties).containsKey("wireTapId")) {
            List<String> parentIds = Arrays.stream(elementProperties.get("wireTapId").split(",")).map(String::trim).toList();
            for (String id : parentIds) {
                if (!((Map)exchange.getProperty("internalProperty_elementExecutionMap")).containsKey(id)) continue;
                ((SessionElementElastic)sessionElement).setParentElementId((String)((Map)exchange.getProperty("internalProperty_elementExecutionMap")).get(id));
            }
        }
        String splitIdChain = (String)exchange.getProperty("internalProperty_splitIdChain");
        ((Map)exchange.getProperty("internalProperty_elementExecutionMap")).put(DebuggerUtils.getNodeIdForExecutionMap(nodeId, splitIdChain), sessionElementId);
        return sessionElement;
    }

    public void logSessionElementAfter(Exchange exchange, Exception externalException, String sessionId, String sessionElementId, Set<String> maskedFields, boolean maskingEnabled) {
        this.logSessionElementAfter(exchange, externalException, this.writer.getSessionElementFromCache(sessionId, sessionElementId), this.extractor.extractBodyForLogging(exchange, maskedFields, maskingEnabled), this.extractor.extractHeadersForLogging(exchange, maskedFields, maskingEnabled), this.extractor.extractContextForLogging(maskedFields, maskingEnabled), this.extractor.extractExchangePropertiesForLogging(exchange, maskedFields, maskingEnabled));
    }

    public void logSessionElementAfter(Exchange exchange, Exception externalException, String sessionId, String sessionElementId, String bodyForLogging, Map<String, String> headersForLogging, Map<String, String> contextHeaders, Map<String, SessionElementProperty> exchangePropertiesForLogging) {
        this.logSessionElementAfter(exchange, externalException, this.writer.getSessionElementFromCache(sessionId, sessionElementId), bodyForLogging, headersForLogging, contextHeaders, exchangePropertiesForLogging);
    }

    private void logSessionElementAfter(Exchange exchange, Exception externalException, SessionElementElastic sessionElement, String bodyForLogging, Map<String, String> headersForLogging, Map<String, String> contextHeaders, Map<String, SessionElementProperty> propertiesForLogging) {
        Exception exception;
        if (sessionElement == null) {
            return;
        }
        String finished = LocalDateTime.now().toString();
        sessionElement.setFinished(finished);
        sessionElement.setBodyAfter(bodyForLogging);
        sessionElement.setHeadersAfter(this.extractor.convertToJson(headersForLogging));
        sessionElement.setPropertiesAfter(this.extractor.convertToJson(propertiesForLogging));
        sessionElement.setContextAfter(this.extractor.convertToJson(contextHeaders));
        Exception exception2 = exception = exchange.getException() != null ? exchange.getException() : externalException;
        if (ChainElementType.isExceptionHandleElement(ChainElementType.fromString(sessionElement.getCamelElementName())) && exception == null && Boolean.TRUE.equals(exchange.getProperty("internalProperty_element_warning", Boolean.class))) {
            sessionElement.setExecutionStatus(ExecutionStatus.COMPLETED_WITH_WARNINGS);
        } else {
            sessionElement.setExecutionStatus(exception != null ? ExecutionStatus.COMPLETED_WITH_ERRORS : ExecutionStatus.COMPLETED_NORMALLY);
        }
        if (Boolean.TRUE.equals(exchange.getProperty("internalProperty_elementFailed", Boolean.class))) {
            sessionElement.setExecutionStatus(ExecutionStatus.COMPLETED_WITH_ERRORS);
            Exception elementException = (Exception)exchange.getProperty("CamelExceptionCaught", Exception.class);
            if (elementException != null) {
                sessionElement.setExceptionInfo(new ExceptionInfo(elementException));
            }
        }
        sessionElement.setDuration(Duration.between(LocalDateTime.parse(sessionElement.getStarted()), LocalDateTime.parse(finished)).toMillis());
        if (exception != null) {
            sessionElement.setExceptionInfo(new ExceptionInfo(exception));
        }
        this.writer.scheduleElementToLogAndCache(sessionElement);
        if (exchange.getProperty("correlationId") != null) {
            Pair<ReadWriteLock, Session> sessionPair = this.writer.getSessionFromCache(exchange.getProperty("internalProperty_sessionId").toString());
            String correlationId = String.valueOf(exchange.getProperty("correlationId"));
            if (sessionPair != null && sessionPair.getRight() != null) {
                ((Session)sessionPair.getRight()).setCorrelationId(correlationId);
            }
        }
    }

    public void putElementToSingleElCache(Exchange exchange, CamelDebuggerProperties dbgProperties, String sessionId, String sessionElementId, String nodeId, String bodyForLogging, Map<String, String> headersForLogging, Map<String, String> contextHeaders, Map<String, SessionElementProperty> exchangePropertiesForLogging) {
        SessionElementElastic sessionElement = this.buildSessionElementBefore(exchange, dbgProperties, sessionId, sessionElementId, nodeId, bodyForLogging, headersForLogging, contextHeaders, exchangePropertiesForLogging);
        this.writer.putToSingleElementCache(sessionId, sessionElement);
    }

    public void putStepElementToSingleElCache(Exchange exchange, CamelDebuggerProperties dbgProperties, String sessionId, String sessionElementId, String stepId, String stepChainElementId) {
        SessionElementElastic sessionElement = this.buildSessionStepElementBefore(exchange, dbgProperties, sessionId, sessionElementId, stepId, stepChainElementId);
        this.writer.putToSingleElementCache(sessionId, sessionElement);
    }

    public String moveFromSingleElCacheToCommonCache(String sessionId) {
        SessionElementElastic element = this.writer.moveFromSingleElementCacheToElementCache(sessionId);
        return element == null ? null : element.getId();
    }

    public Boolean sessionShouldBeLogged() {
        return this.random.nextDouble() <= this.samplerProbabilistic;
    }

    private void updateSessionInfoForElements(Exchange exchange, SessionElementElastic sessionElement) {
        String sessionId = exchange.getProperty("internalProperty_sessionId").toString();
        Pair<ReadWriteLock, Session> sessionPair = this.writer.getSessionFromCache(sessionId);
        this.updateSessionInfoForElements(sessionPair != null && sessionPair.getRight() != null ? (Session)sessionPair.getRight() : null, sessionElement);
    }

    private void updateSessionInfoForElements(Session session, SessionElementElastic sessionElement) {
        sessionElement.updateRelatedSessionData(session);
    }

    @Nullable
    private String extractParentId(Exchange exchange, String sessionId, Map<String, String> elementProperties) {
        String parentElementId = null;
        boolean hasIntermediateParents = false;
        String parentStepId = null;
        String splitPostfix = (String)exchange.getProperty("internalProperty_splitIdChain", (Object)"", String.class);
        Map executionMap = (Map)exchange.getProperty("internalProperty_elementExecutionMap");
        if (elementProperties.containsKey("parentElementId")) {
            parentElementId = elementProperties.get("parentElementId");
            parentStepId = (String)executionMap.get(DebuggerUtils.getNodeIdForExecutionMap(parentElementId, splitPostfix));
            if (parentStepId == null) {
                parentStepId = (String)executionMap.get(parentElementId);
            } else {
                parentElementId = DebuggerUtils.getNodeIdForExecutionMap(parentElementId, splitPostfix);
            }
            hasIntermediateParents = Boolean.parseBoolean(elementProperties.get("hasIntermediateParents"));
        } else if (elementProperties.containsKey("reuseOriginalId")) {
            String reuseOriginalId = elementProperties.get("reuseOriginalId");
            parentElementId = (String)exchange.getProperty(String.format("internalProperty_%s_currentReuseReferenceParentId", reuseOriginalId));
            if (parentElementId != null) {
                parentStepId = (String)executionMap.get(DebuggerUtils.getNodeIdForExecutionMap(parentElementId, splitPostfix));
                if (parentStepId == null) {
                    parentStepId = (String)executionMap.get(parentElementId);
                } else {
                    parentElementId = DebuggerUtils.getNodeIdForExecutionMap(parentElementId, splitPostfix);
                }
            }
            hasIntermediateParents = Boolean.parseBoolean(String.valueOf(exchange.getProperty(String.format("internalProperty_%s_hasIntermediateParents", reuseOriginalId))));
        }
        if (StringUtils.isNotEmpty((CharSequence)parentElementId) && hasIntermediateParents) {
            parentStepId = this.findIntermediateParentId(sessionId, parentElementId, executionMap).orElse(parentStepId);
        }
        return StringUtils.isNotEmpty(parentStepId) ? parentStepId : (String)((Deque)exchange.getProperty("internalProperty_steps")).peek();
    }

    private Optional<String> findIntermediateParentId(String sessionId, String parentChainElementId, Map<String, String> executionMap) {
        Optional<String> intermediateParentId = Optional.empty();
        Collection<SessionElementElastic> sessionElements = this.writer.getSessionElementsFromCache(sessionId);
        LinkedList<SessionElementElastic> elementsQueue = new LinkedList<SessionElementElastic>();
        String parentSessionElementId = executionMap.get(parentChainElementId);
        SessionElementElastic parentSessionElement = sessionElements.stream().filter(sessionElement -> StringUtils.equals((CharSequence)sessionElement.getId(), (CharSequence)parentSessionElementId)).findFirst().orElse(null);
        if (parentSessionElement != null) {
            intermediateParentId = Optional.ofNullable(parentSessionElement.getId());
            elementsQueue.offer(parentSessionElement);
        }
        while (!elementsQueue.isEmpty()) {
            SessionElementElastic currentParentElement = (SessionElementElastic)elementsQueue.poll();
            Optional<SessionElementElastic> foundChildElement = sessionElements.stream().filter(sessionElement -> StringUtils.equals((CharSequence)currentParentElement.getId(), (CharSequence)sessionElement.getParentElementId()) && StringUtils.equals((CharSequence)parentSessionElement.getChainElementId(), (CharSequence)sessionElement.getChainElementId()) && executionMap.containsValue(sessionElement.getId())).filter(sessionElement -> sessionElement.getExecutionStatus() == ExecutionStatus.IN_PROGRESS).findAny();
            if (!foundChildElement.isPresent()) continue;
            SessionElementElastic intermediateSessionElement = foundChildElement.get();
            intermediateParentId = Optional.ofNullable(intermediateSessionElement.getId());
            elementsQueue.offer(intermediateSessionElement);
        }
        return intermediateParentId;
    }
}

