/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.sessions.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.opensearch.client.opensearch.core.BulkRequest;
import org.opensearch.client.opensearch.core.BulkResponse;
import org.opensearch.client.opensearch.core.bulk.BulkOperation;
import org.opensearch.client.opensearch.core.bulk.BulkResponseItem;
import org.opensearch.client.opensearch.core.bulk.IndexOperation;
import org.qubership.integration.platform.sessions.dto.Session;
import org.qubership.integration.platform.sessions.dto.opensearch.SessionElementElastic;
import org.qubership.integration.platform.sessions.exception.ImportConflictException;
import org.qubership.integration.platform.sessions.exception.ImportException;
import org.qubership.integration.platform.sessions.mapper.SessionElementMapper;
import org.qubership.integration.platform.sessions.opensearch.OpenSearchClientSupplier;
import org.qubership.integration.platform.sessions.properties.opensearch.OpenSearchProperties;
import org.qubership.integration.platform.sessions.properties.sessions.SessionsProperties;
import org.qubership.integration.platform.sessions.service.SessionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ImportService {
    private static final Logger log = LoggerFactory.getLogger(ImportService.class);
    private final String indexName;
    private final int bulkRequestMaxSizeBytes;
    private final int bulkRequestPayloadSizeThresholdBytes;
    private final int bulkRequestElementsCountThreshold;
    private final ObjectMapper objectMapper;
    private final SessionElementMapper elementMapper;
    private final OpenSearchClientSupplier openSearchClientSupplier;
    private final SessionService sessionService;

    @Autowired
    public ImportService(ObjectMapper objectMapper, SessionElementMapper elementMapper, SessionsProperties sessionsProperties, OpenSearchClientSupplier openSearchClientSupplier, OpenSearchProperties openSearchProperties, SessionService sessionService) {
        this.indexName = openSearchProperties.index().elements().name();
        this.objectMapper = objectMapper;
        this.elementMapper = elementMapper;
        this.openSearchClientSupplier = openSearchClientSupplier;
        this.sessionService = sessionService;
        this.bulkRequestMaxSizeBytes = sessionsProperties.bulkRequest().maxSizeKb() * 1024;
        this.bulkRequestPayloadSizeThresholdBytes = sessionsProperties.bulkRequest().payloadSizeThresholdKb() * 1024;
        this.bulkRequestElementsCountThreshold = sessionsProperties.bulkRequest().elementsCountThreshold();
    }

    public List<Session> importSessions(MultipartFile[] files) {
        ArrayList<Session> resultSessions = new ArrayList<Session>();
        for (MultipartFile file : files) {
            List<Session> sessions;
            try {
                sessions = Arrays.asList((Session[])this.objectMapper.readValue(new String(file.getBytes()), Session[].class));
            }
            catch (IOException error) {
                log.error("Error while reading file: {}", (Object)error.getMessage());
                throw new ImportException("Error while reading file " + file.getOriginalFilename(), (Exception)error);
            }
            this.checkExisting(file.getOriginalFilename(), sessions, resultSessions);
            log.debug("Found {} sessions in file {}", (Object)sessions.size(), (Object)file.getName());
            sessions.forEach(session -> session.setChainId(null));
            sessions.forEach(session -> session.setImportedSession(true));
            List sessionElements = this.elementMapper.toElements(sessions);
            this.writeElements(sessionElements);
            resultSessions.addAll(sessions);
        }
        resultSessions.forEach(session -> session.setSessionElements(null));
        return resultSessions;
    }

    private void checkExisting(String filename, List<Session> sessions, List<Session> resultSessions) {
        HashSet<String> existingIds = new HashSet<String>();
        for (Session session : sessions) {
            if (this.sessionService.findById(session.getId(), "sessionId", true, false) == null && sessions.stream().filter(s -> s.getId().equals(session.getId())).count() <= 1L && !resultSessions.stream().anyMatch(s -> s.getId().equals(session.getId()))) continue;
            existingIds.add(session.getId());
        }
        if (!existingIds.isEmpty()) {
            log.error("File {} can't be imported because of sessions duplicates: {}", (Object)filename, existingIds);
            throw new ImportConflictException(String.format("File %s can't be imported because of sessions duplicates: %s", filename, existingIds));
        }
    }

    private void writeElements(List<SessionElementElastic> sessionElements) {
        int bulkRequestSize = 0;
        ArrayList<BulkOperation> updateRequests = new ArrayList<BulkOperation>();
        Iterator<SessionElementElastic> iterator = sessionElements.iterator();
        while (iterator.hasNext()) {
            byte[] payload;
            SessionElementElastic element = iterator.next();
            try {
                payload = this.objectMapper.writeValueAsBytes((Object)element);
            }
            catch (JsonProcessingException error) {
                log.error("Failed to parse sessions write request. Element skipped");
                throw new ImportException("Failed to parse sessions write request on element " + element.getElementName() + " in chain " + element.getChainName(), (Exception)((Object)error));
            }
            int payloadSize = payload.length;
            BulkOperation request = (BulkOperation)new BulkOperation.Builder().index(IndexOperation.of(io -> ((IndexOperation.Builder)((IndexOperation.Builder)((IndexOperation.Builder)io.index(this.openSearchClientSupplier.normalize(this.indexName))).id(element.getId())).requireAlias(Boolean.valueOf(true))).document((Object)element))).build();
            try {
                boolean needToExecuteBulk;
                if (payloadSize >= this.bulkRequestPayloadSizeThresholdBytes || sessionElements.size() <= this.bulkRequestElementsCountThreshold) {
                    this.executeBulk(new ArrayList<BulkOperation>(List.of(request)));
                } else {
                    updateRequests.add(request);
                    bulkRequestSize += payloadSize;
                }
                if (!(needToExecuteBulk = bulkRequestSize >= this.bulkRequestMaxSizeBytes || !iterator.hasNext() && !updateRequests.isEmpty())) continue;
                this.executeBulk(updateRequests);
                bulkRequestSize = 0;
            }
            catch (Exception error) {
                log.error("While sessions writing an error has occurred", (Throwable)error);
                throw new ImportException("Import was failed while saving to opensearch", error);
            }
        }
    }

    private void executeBulk(List<BulkOperation> updateRequests) throws IOException {
        BulkRequest bulkRequest = new BulkRequest.Builder().index(this.openSearchClientSupplier.normalize(this.indexName)).requireAlias(Boolean.valueOf(true)).operations(updateRequests).build();
        BulkResponse bulk = this.openSearchClientSupplier.getClient().bulk(bulkRequest);
        updateRequests.clear();
        this.checkAndLogFailedElements(bulk);
    }

    private void checkAndLogFailedElements(BulkResponse response) {
        String separator = System.getProperty("line.separator");
        StringBuilder errorMessages = new StringBuilder(separator);
        for (BulkResponseItem bulkItemResponse : response.items()) {
            if (bulkItemResponse.error() == null) continue;
            errorMessages.append(bulkItemResponse.error().reason());
            errorMessages.append(separator);
        }
        if (errorMessages.toString().isBlank()) {
            return;
        }
        errorMessages.insert(0, "Some sessions elements can't be saved to opensearch:");
        throw new ImportException(errorMessages.toString());
    }
}

