/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.sessions.configuration;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.servers.Server;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
public class SwaggerAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(SwaggerAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public OpenAPI getApi() {
        OpenAPI openAPI = new OpenAPI().addServersItem(new Server().url("/")).info(this.getInfo());
        return openAPI;
    }

    private Info getInfo() {
        return new Info().title("Qubership Integration Platform Sessions Management").description("REST API of Qubership Integration Platform Sessions Management microservice").extensions(Map.of("x-api-kind", "no-bwc")).version("v1");
    }
}

