/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.sessions.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.qubership.integration.platform.sessions.dto.Session;
import org.qubership.integration.platform.sessions.service.ImportService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/v1/sessions/import"})
@Tag(name="import-controller", description="Import Controller")
public class ImportController {
    private static final Logger log = LoggerFactory.getLogger(ImportController.class);
    private final ImportService importService;

    @Autowired
    public ImportController(ImportService importService) {
        this.importService = importService;
    }

    @Operation(description="Import session(s) from file")
    @PostMapping
    public ResponseEntity<List<Session>> importSessions(@RequestParam @Parameter(description="List of files to import") MultipartFile[] files) {
        log.debug("Request to import sessions");
        return ResponseEntity.ok((Object)this.importService.importSessions(files));
    }
}

