/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.sessions.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.qubership.integration.platform.sessions.dto.Session;
import org.qubership.integration.platform.sessions.dto.SessionElement;
import org.qubership.integration.platform.sessions.dto.SessionSearchResponse;
import org.qubership.integration.platform.sessions.dto.filter.FilterRequestAndSearchDTO;
import org.qubership.integration.platform.sessions.exception.SessionsNotFoundException;
import org.qubership.integration.platform.sessions.service.CatalogInternalService;
import org.qubership.integration.platform.sessions.service.SessionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/sessions"})
@Tag(name="session-controller", description="Session Controller")
public class SessionController {
    private static final Logger log = LoggerFactory.getLogger(SessionController.class);
    private final SessionService sessionService;
    private final CatalogInternalService catalogInternalService;

    @Autowired
    public SessionController(SessionService sessionService, CatalogInternalService catalogInternalService) {
        this.sessionService = sessionService;
        this.catalogInternalService = catalogInternalService;
    }

    @Operation(extensions={@Extension(properties={@ExtensionProperty(name="x-api-kind", value="bwc")})}, description="Get session by specified external id")
    @GetMapping(value={"/external-id/{externalSessionId}"})
    public ResponseEntity<Session> findByExternalId(@PathVariable @Parameter(description="External id that was specified during chain execution") String externalSessionId, @RequestParam(required=false, defaultValue="false") @Parameter(description="Whether we need to include session elements(steps) in the response") boolean includeDetails) {
        Session session;
        if (log.isDebugEnabled()) {
            log.debug("Request to find session by external id {}", (Object)externalSessionId);
        }
        if ((session = this.sessionService.findByExternalSessionId(externalSessionId, includeDetails)) == null) {
            throw new SessionsNotFoundException("Can't find session by external id " + externalSessionId);
        }
        return ResponseEntity.ok((Object)session);
    }

    @GetMapping(value={"/{sessionId}"})
    @Operation(description="Get session with all elements (steps) by session id")
    public ResponseEntity<Session> findById(@PathVariable @Parameter(description="Session id") String sessionId) {
        Session session;
        if (log.isDebugEnabled()) {
            log.debug("Request to find session by id {}", (Object)sessionId);
        }
        if ((session = this.sessionService.findById(sessionId, "sessionId", true, true)) == null) {
            throw new SessionsNotFoundException("Can't find session " + sessionId);
        }
        return ResponseEntity.ok((Object)session);
    }

    @RequestMapping(method={RequestMethod.HEAD}, value={"/{sessionId}"})
    @Operation(description="Find session by id if it exists", extensions={@Extension(properties={@ExtensionProperty(name="x-api-kind", value="bwc")})})
    public ResponseEntity<Session> findExistingSession(@PathVariable String sessionId) {
        Session session = this.sessionService.findById(sessionId, "sessionId", true, false);
        if (session == null) {
            throw new SessionsNotFoundException("Can't find session " + sessionId);
        }
        return ResponseEntity.ok((Object)session);
    }

    @PostMapping
    @Operation(description="Get light list of sessions without session elements (steps) with additional parameters")
    public ResponseEntity<SessionSearchResponse> findAllByFilter(@RequestParam(required=false, defaultValue="0") @Parameter(description="Which session number should we start from") int offset, @RequestParam(required=false, defaultValue="20") @Parameter(description="Amount of sessions received at a time") int count, @RequestParam(required=false, defaultValue="sessionStarted") @Parameter(description="Name of column we should sort response by") String sortColumn, @RequestBody @Parameter(description="Additional filters request object") FilterRequestAndSearchDTO filterRequest) {
        ResponseEntity response = this.findByFilter(null, offset, count, sortColumn, filterRequest);
        SessionSearchResponse body = (SessionSearchResponse)response.getBody();
        if (body != null) {
            try {
                Set chainIds = body.getSessions().stream().map(Session::getChainId).collect(Collectors.toSet());
                Map chainsNames = this.catalogInternalService.getChainsNames(chainIds);
                body.getSessions().forEach(session -> session.setChainName(chainsNames.getOrDefault(session.getChainId(), session.getChainName())));
            }
            catch (Exception e) {
                log.warn("Failed to receive actual chains names for sessions", (Throwable)e);
            }
        }
        return response;
    }

    @PostMapping(value={"/chains/{chainId}"})
    @Operation(description="Get light list of sessions for specified chain without session elements (steps) with additional parameters")
    public ResponseEntity<SessionSearchResponse> findByFilter(@PathVariable @Nullable @Parameter(description="Only sessions executed on chain with specified id will be shown") String chainId, @RequestParam(required=false, defaultValue="0") @Parameter(description="Which session number should we start from") int offset, @RequestParam(required=false, defaultValue="20") @Parameter(description="Amount of sessions received at a time") int count, @RequestParam(required=false, defaultValue="sessionStarted") @Parameter(description="Name of column we should sort response by") String sortColumn, @RequestBody @Parameter(description="Additional filters request object") FilterRequestAndSearchDTO filterRequest) {
        if (log.isDebugEnabled()) {
            if (chainId != null) {
                log.debug("Request to find previews by chain id: {}", (Object)chainId);
            } else {
                log.debug("Request to find previews");
            }
        }
        return ResponseEntity.ok((Object)this.sessionService.getSessions(chainId, offset, count, sortColumn, filterRequest));
    }

    @GetMapping(value={"/{sessionId}/{elementId}"})
    @Operation(description="Get element(step) with payload (body) for specified element(step)")
    public ResponseEntity<SessionElement> getElementPayloadById(@PathVariable @Parameter(description="Session id") String sessionId, @PathVariable @Parameter(description="Element (step) id within specified session") String elementId) {
        SessionElement element;
        if (log.isDebugEnabled()) {
            log.debug("Request to find Session Element payload from session {} by id {}", (Object)sessionId, (Object)elementId);
        }
        if ((element = this.sessionService.getElementById(elementId)) == null) {
            throw new SessionsNotFoundException("Can't find element with id " + elementId);
        }
        return ResponseEntity.ok((Object)element);
    }

    @DeleteMapping(value={"/{sessionId}"})
    @Operation(description="Delete specified session")
    public ResponseEntity<Void> deleteById(@PathVariable @Parameter(description="Session id") String sessionId) {
        log.info("Request to delete session by id: {}", (Object)sessionId);
        this.sessionService.deleteBySessionId(sessionId);
        return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
    }

    @Operation(description="Delete all sessions for specified chain")
    @DeleteMapping(value={"/chains/{chainId}"})
    public ResponseEntity<Void> deleteAllByChainId(@PathVariable @Parameter(description="Chain id") String chainId) {
        log.info("Request to delete all sessions by chain id: {}", (Object)chainId);
        this.sessionService.deleteByChainId(chainId);
        return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
    }

    @Operation(description="Bulk delete sessions")
    @PostMapping(value={"/bulk-delete"})
    public ResponseEntity<Void> deleteByIds(@RequestBody List<String> sessionIds) {
        log.info("Request to delete sessions by ids: {}", sessionIds);
        this.sessionService.deleteBySessionIds(sessionIds);
        return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
    }

    @Operation(description="Delete all sessions for specified chains")
    @DeleteMapping(value={"/chains"})
    public ResponseEntity<Void> deleteAllByChainIds(@RequestParam @Parameter(description="List of chain ids separated by comma") List<String> chainIds) {
        log.info("Request to delete all sessions by chains ids: {}", chainIds);
        this.sessionService.deleteAllByChainIds(chainIds);
        return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
    }

    @Operation(description="Delete all sessions from all chains")
    @DeleteMapping(value={""})
    public ResponseEntity<Void> deleteAllSessions() {
        log.info("Request to delete all sessions");
        this.sessionService.deleteAllSessions();
        return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
    }
}

