/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.sessions.exception;

import java.sql.Timestamp;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.qubership.integration.platform.sessions.dto.ExceptionDTO;
import org.qubership.integration.platform.sessions.exception.ImportConflictException;
import org.qubership.integration.platform.sessions.exception.ImportException;
import org.qubership.integration.platform.sessions.exception.SearchException;
import org.qubership.integration.platform.sessions.exception.SessionsNotFoundException;
import org.qubership.integration.platform.sessions.exception.SessionsRuntimeException;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class GlobalExceptionHandler {
    private static final String NO_STACKTRACE_AVAILABLE_MESSAGE = "No Stacktrace Available";

    @ExceptionHandler
    public ResponseEntity<ExceptionDTO> handleGeneralException(Exception exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)this.getExceptionDTO(exception));
    }

    @ExceptionHandler(value={SessionsNotFoundException.class})
    public ResponseEntity<ExceptionDTO> sessionsNotFoundExceptionHandler(SessionsNotFoundException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)this.getExceptionDTO(exception));
    }

    @ExceptionHandler(value={SearchException.class})
    public ResponseEntity<ExceptionDTO> searchExceptionHandler(SearchException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)this.getExceptionDTO(exception));
    }

    @ExceptionHandler(value={ImportException.class})
    public ResponseEntity<ExceptionDTO> importExceptionHandler(ImportException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)this.getExceptionDTO(exception));
    }

    @ExceptionHandler(value={ImportConflictException.class})
    public ResponseEntity<ExceptionDTO> importConflictExceptionHandler(ImportConflictException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body((Object)this.getExceptionDTO(exception));
    }

    private ExceptionDTO getExceptionDTO(Exception exception) {
        String message = exception.getMessage();
        String stacktrace = NO_STACKTRACE_AVAILABLE_MESSAGE;
        if (exception instanceof SessionsRuntimeException) {
            SessionsRuntimeException sessionsRuntimeException = (SessionsRuntimeException)exception;
            if (sessionsRuntimeException.getOriginalException() != null) {
                stacktrace = ExceptionUtils.getStackTrace((Throwable)sessionsRuntimeException.getOriginalException());
            }
        } else {
            stacktrace = ExceptionUtils.getStackTrace((Throwable)exception);
        }
        return ExceptionDTO.builder().errorMessage(message).stacktrace(stacktrace).errorDate(new Timestamp(System.currentTimeMillis()).toString()).build();
    }
}

