/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.sessions.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch._types.FieldSort;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.SortOptions;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch._types.query_dsl.BoolQuery;
import org.opensearch.client.opensearch._types.query_dsl.MatchAllQuery;
import org.opensearch.client.opensearch._types.query_dsl.MatchPhrasePrefixQuery;
import org.opensearch.client.opensearch._types.query_dsl.MultiMatchQuery;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.RangeQuery;
import org.opensearch.client.opensearch._types.query_dsl.TermQuery;
import org.opensearch.client.opensearch._types.query_dsl.TermsQuery;
import org.opensearch.client.opensearch._types.query_dsl.TermsQueryField;
import org.opensearch.client.opensearch._types.query_dsl.TextQueryType;
import org.opensearch.client.opensearch._types.query_dsl.WildcardQuery;
import org.opensearch.client.opensearch.core.DeleteByQueryRequest;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.search.FieldCollapse;
import org.opensearch.client.opensearch.core.search.Hit;
import org.opensearch.client.opensearch.core.search.InnerHits;
import org.opensearch.client.opensearch.core.search.InnerHitsResult;
import org.opensearch.client.transport.TransportOptions;
import org.opensearch.client.transport.httpclient5.ApacheHttpClient5Options;
import org.opensearch.client.transport.httpclient5.HttpAsyncResponseConsumerFactory;
import org.qubership.integration.platform.sessions.dto.Session;
import org.qubership.integration.platform.sessions.dto.SessionElement;
import org.qubership.integration.platform.sessions.dto.SessionSearchResponse;
import org.qubership.integration.platform.sessions.dto.filter.FilterCondition;
import org.qubership.integration.platform.sessions.dto.filter.FilterRequest;
import org.qubership.integration.platform.sessions.dto.filter.FilterRequestAndSearchDTO;
import org.qubership.integration.platform.sessions.dto.opensearch.SessionElementElastic;
import org.qubership.integration.platform.sessions.exception.SearchException;
import org.qubership.integration.platform.sessions.mapper.SessionAggregateMapper;
import org.qubership.integration.platform.sessions.mapper.SessionElementMapper;
import org.qubership.integration.platform.sessions.opensearch.OpenSearchClientSupplier;
import org.qubership.integration.platform.sessions.properties.opensearch.OpenSearchProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SessionService {
    private static final Logger log = LoggerFactory.getLogger(SessionService.class);
    private static final String[] EXCLUDE_FIELD_IN_SESSIONS = new String[]{"bodyBefore", "bodyAfter", "headersBefore", "headersAfter", "exchangePropertiesBefore", "exchangePropertiesAfter", "propertiesAfter", "propertiesBefore", "contextBefore", "contextAfter"};
    private static final String AGGREGATION_COLUMN = "sessionId";
    private static final List<String> SESSION_OPENSEARCH_FIELDS = Arrays.asList("sessionId", "sessionStarted", "sessionFinished", "sessionDuration", "sessionExecutionStatus", "chainId", "chainName", "engineAddress", "loggingLevel", "sessionSyncDuration");
    private static final int SCROLL_WINDOW = 300;
    private static final String ELEMENT_EXECUTION_ERROR_MESSAGE = "Error during element execution";
    public static final String SESSION_ID_KEY = "sessionId";
    public static final String CHAIN_ID_KEY = "chainId";
    public static final String EXTERNAL_SESSION_ID_KEY = "externalSessionId";
    public static final String STARTED_KEY = "started";
    private static final String ID_KEY = "id";
    private static final String SESSION_DURATION_KEY = "sessionDuration";
    private static final String INNER_HIT_NAME = "most_recent";
    private final String indexName;
    private final SessionAggregateMapper sessionMapper;
    private final SessionElementMapper sessionElementMapper;
    private final OpenSearchClientSupplier openSearchClientSupplier;
    private final HttpAsyncResponseConsumerFactory consumerFactory;

    @Autowired
    public SessionService(SessionAggregateMapper sessionMapper, OpenSearchClientSupplier openSearchClientSupplier, ObjectMapper mapper, SessionElementMapper sessionElementMapper, OpenSearchProperties openSearchProperties) {
        this.indexName = openSearchProperties.index().elements().name();
        this.sessionMapper = sessionMapper;
        this.openSearchClientSupplier = openSearchClientSupplier;
        this.sessionElementMapper = sessionElementMapper;
        this.consumerFactory = new HttpAsyncResponseConsumerFactory.HeapBufferedResponseConsumerFactory(openSearchProperties.session().defaultBufferLimit().intValue());
    }

    public Session findByExternalSessionId(String externalSessionId, boolean includeElements) {
        return this.findById(externalSessionId, EXTERNAL_SESSION_ID_KEY, !includeElements, includeElements);
    }

    public Session findById(String id, String idKey, boolean light, boolean includeElements) {
        List<SessionElementElastic> singleResponse;
        ArrayList<SessionElementElastic> elements = new ArrayList<SessionElementElastic>();
        int i = 0;
        do {
            singleResponse = this.getSearchResponse(this.getScrollSearchRequest(id, idKey, light, i * 300));
            elements.addAll(singleResponse);
            ++i;
        } while (!singleResponse.isEmpty());
        return this.sessionMapper.toSession(elements, includeElements);
    }

    private SearchRequest getScrollSearchRequest(String id, String idKey, boolean light, int scrollWindow) {
        SearchRequest.Builder requestBuilder = new SearchRequest.Builder().index(this.openSearchClientSupplier.normalize(this.indexName), new String[0]).size(Integer.valueOf(300)).query(new TermQuery.Builder().field(idKey).value(FieldValue.of((String)id)).build().toQuery()).sort((SortOptions)new SortOptions.Builder().field(new FieldSort.Builder().field(STARTED_KEY).order(SortOrder.Asc).build()).build(), new SortOptions[0]);
        this.configureSessionElementsCollapseBy(requestBuilder, ID_KEY);
        if (light) {
            requestBuilder.source(builder -> builder.filter(builder1 -> builder1.excludes(Arrays.asList(EXCLUDE_FIELD_IN_SESSIONS))));
        }
        requestBuilder.from(Integer.valueOf(scrollWindow));
        return requestBuilder.build();
    }

    public SessionElement getElementById(String elementId) {
        SearchRequest.Builder requestBuilder = new SearchRequest.Builder().index(this.openSearchClientSupplier.normalize(this.indexName), new String[0]).size(Integer.valueOf(300)).query(new TermQuery.Builder().field(ID_KEY).value(FieldValue.of((String)elementId)).build().toQuery()).sort((SortOptions)new SortOptions.Builder().field(new FieldSort.Builder().field(STARTED_KEY).order(SortOrder.Asc).build()).build(), new SortOptions[0]);
        this.configureSessionElementsCollapseBy(requestBuilder, ID_KEY);
        List<SessionElementElastic> response = this.getSearchResponse(requestBuilder.build());
        return response.stream().findFirst().map(this.sessionElementMapper::toSessionElement).orElse(null);
    }

    public void deleteBySessionId(String sessionId) {
        this.deleteByField("sessionId", sessionId, false);
    }

    public void deleteByChainId(String chainId) {
        this.deleteByField(CHAIN_ID_KEY, chainId, true);
    }

    public void deleteAllSessions() {
        DeleteByQueryRequest request = new DeleteByQueryRequest.Builder().index(this.openSearchClientSupplier.normalize(this.indexName), new String[0]).query(new MatchAllQuery.Builder().build().toQuery()).refresh(Boolean.valueOf(true)).build();
        this.delete(request);
    }

    public void deleteByField(String fieldName, String value, boolean refresh) {
        DeleteByQueryRequest request = new DeleteByQueryRequest.Builder().index(this.openSearchClientSupplier.normalize(this.indexName), new String[0]).query(new TermQuery.Builder().field(fieldName).value(FieldValue.of((String)value)).build().toQuery()).refresh(Boolean.valueOf(refresh)).build();
        this.delete(request);
    }

    public void deleteByFieldValues(String fieldName, List<String> values, boolean refresh) {
        Query query = new TermsQuery.Builder().field(fieldName).terms((TermsQueryField)new TermsQueryField.Builder().value(values.stream().map(FieldValue::of).toList()).build()).build().toQuery();
        DeleteByQueryRequest request = new DeleteByQueryRequest.Builder().index(this.openSearchClientSupplier.normalize(this.indexName), new String[0]).query(query).refresh(Boolean.valueOf(true)).build();
        this.delete(request);
    }

    public void deleteAllByChainIds(List<String> chainIds) {
        this.deleteByFieldValues(CHAIN_ID_KEY, chainIds, true);
    }

    public void deleteBySessionIds(List<String> sessionIds) {
        this.deleteByFieldValues("sessionId", sessionIds, true);
    }

    public SessionSearchResponse getSessions(String chainId, int offset, int limit, String sortColumn, FilterRequestAndSearchDTO filterRequest) {
        if (offset < 0 || limit < 1) {
            return new SessionSearchResponse(0, Collections.emptyList());
        }
        if (!SESSION_OPENSEARCH_FIELDS.contains(sortColumn)) {
            throw new IllegalArgumentException("Can't sort results on this column. Valid columns are: " + StringUtils.join(SESSION_OPENSEARCH_FIELDS, (String)", "));
        }
        LinkedHashMap resultSessions = new LinkedHashMap();
        List<SessionElementElastic> lightSessionElements = this.executeLightSessionElementsQuery(chainId, offset, limit, sortColumn, filterRequest);
        lightSessionElements.forEach(element -> resultSessions.put(element.getSessionId(), element));
        return new SessionSearchResponse(offset + resultSessions.size(), this.sessionMapper.toPreview(new ArrayList<SessionElementElastic>(resultSessions.values())));
    }

    private void configureSessionElementsCollapseBy(SearchRequest.Builder builder, String field) {
        FieldCollapse collapse = new FieldCollapse.Builder().field(field).innerHits(new InnerHits.Builder().name(INNER_HIT_NAME).sort((SortOptions)new SortOptions.Builder().field(new FieldSort.Builder().field(SESSION_DURATION_KEY).order(SortOrder.Desc).build()).build(), new SortOptions[0]).size(Integer.valueOf(1)).build(), new InnerHits[0]).build();
        builder.collapse(collapse);
    }

    private List<SessionElementElastic> executeLightSessionElementsQuery(String chainId, int offset, int count, String sortColumn, FilterRequestAndSearchDTO filterAndSearch) {
        String searchString;
        SearchRequest.Builder requestBuilder = new SearchRequest.Builder().index(this.openSearchClientSupplier.normalize(this.indexName), new String[0]);
        BoolQuery.Builder queryBuilder = new BoolQuery.Builder();
        if (StringUtils.isNotEmpty((CharSequence)chainId)) {
            queryBuilder.must(new TermQuery.Builder().field(CHAIN_ID_KEY).value(FieldValue.of((String)chainId)).build().toQuery(), new Query[0]);
        }
        if (StringUtils.isNotEmpty((CharSequence)(searchString = filterAndSearch.getSearchString()))) {
            queryBuilder.must(List.of(new BoolQuery.Builder().should(new TermQuery.Builder().field("sessionId").value(FieldValue.of((String)searchString)).build().toQuery(), new Query[]{new MultiMatchQuery.Builder().query(searchString).type(TextQueryType.PhrasePrefix).fields("bodyAfter", new String[]{"bodyBefore", "headersAfter", "headersBefore", "exchangePropertiesAfter", "exchangePropertiesBefore", "contextAfter", "contextBefore"}).build().toQuery()}).build().toQuery()));
        }
        for (FilterRequest filterRequest : filterAndSearch.getFilterRequestList()) {
            switch (filterRequest.getFeature()) {
                case ENGINE: {
                    this.getPredicate(filterRequest.getCondition(), queryBuilder, "engineAddress", filterRequest.getValue());
                    break;
                }
                case STATUS: {
                    this.getPredicate(filterRequest.getCondition(), queryBuilder, "sessionExecutionStatus", filterRequest.getValue());
                    break;
                }
                case CHAIN_NAME: {
                    this.getPredicate(filterRequest.getCondition(), queryBuilder, "chainName", filterRequest.getValue());
                    break;
                }
                case START_TIME: {
                    this.getPredicate(filterRequest.getCondition(), queryBuilder, "sessionStarted", filterRequest.getValue());
                    break;
                }
                case FINISH_TIME: {
                    this.getPredicate(filterRequest.getCondition(), queryBuilder, "sessionFinished", filterRequest.getValue());
                }
            }
        }
        requestBuilder.query(queryBuilder.build().toQuery()).sort((SortOptions)new SortOptions.Builder().field(new FieldSort.Builder().field(sortColumn).order(SortOrder.Desc).build()).build(), new SortOptions[0]).sort((SortOptions)new SortOptions.Builder().field(new FieldSort.Builder().field("sessionId").build()).build(), new SortOptions[0]).from(Integer.valueOf(offset)).size(Integer.valueOf(count)).sort((SortOptions)new SortOptions.Builder().field(new FieldSort.Builder().field(STARTED_KEY).order(SortOrder.Asc).build()).build(), new SortOptions[0]).source(builder -> builder.filter(builder1 -> builder1.excludes(Arrays.asList(EXCLUDE_FIELD_IN_SESSIONS))));
        this.configureSessionElementsCollapseBy(requestBuilder, "sessionId");
        return this.getSearchResponse(requestBuilder.build());
    }

    private void getPredicate(FilterCondition condition, BoolQuery.Builder queryBuilder, String fieldName, String value) {
        switch (condition) {
            case IN: {
                queryBuilder.must(new TermsQuery.Builder().field(fieldName).terms((TermsQueryField)new TermsQueryField.Builder().value(Arrays.stream(value.split(",")).map(FieldValue::of).toList()).build()).build().toQuery(), new Query[0]);
                break;
            }
            case NOT_IN: {
                queryBuilder.mustNot(new TermsQuery.Builder().field(fieldName).terms((TermsQueryField)new TermsQueryField.Builder().value(Arrays.stream(value.split(",")).map(FieldValue::of).toList()).build()).build().toQuery(), new Query[0]);
                break;
            }
            case CONTAINS: {
                queryBuilder.must(new WildcardQuery.Builder().field(fieldName).value("*" + value + "*").build().toQuery(), new Query[0]);
                break;
            }
            case DOES_NOT_CONTAIN: {
                queryBuilder.mustNot(new WildcardQuery.Builder().field(fieldName).value("*" + value + "*").build().toQuery(), new Query[0]);
                break;
            }
            case STARTS_WITH: {
                queryBuilder.must(new MatchPhrasePrefixQuery.Builder().field(fieldName).query(value).build().toQuery(), new Query[0]);
                break;
            }
            case ENDS_WITH: {
                queryBuilder.must(new WildcardQuery.Builder().field(fieldName).value("*" + value).build().toQuery(), new Query[0]);
                break;
            }
            case IS_AFTER: {
                Date date = new Date(Long.parseLong(value));
                queryBuilder.must(new RangeQuery.Builder().field(fieldName).gte(JsonData.of((Object)date)).build().toQuery(), new Query[0]);
                break;
            }
            case IS_BEFORE: {
                Date date = new Date(Long.parseLong(value));
                queryBuilder.must(new RangeQuery.Builder().field(fieldName).lte(JsonData.of((Object)date)).build().toQuery(), new Query[0]);
                break;
            }
            case IS_WITHIN: {
                String[] values = value.split(",");
                queryBuilder.must(new RangeQuery.Builder().field("sessionFinished").gte(JsonData.of((Object)new Date(Long.parseLong(values[0])))).lte(JsonData.of((Object)new Date(Long.parseLong(values[1])))).build().toQuery(), new Query[0]);
            }
        }
    }

    private List<SessionElementElastic> getSearchResponse(SearchRequest request) {
        SearchResponse response;
        try {
            ApacheHttpClient5Options.Builder optionsBuilder = ApacheHttpClient5Options.DEFAULT.toBuilder();
            optionsBuilder.setHttpAsyncResponseConsumerFactory(this.consumerFactory);
            response = this.openSearchClientSupplier.getClient().withTransportOptions((TransportOptions)optionsBuilder.build()).search(request, SessionElementElastic.class);
        }
        catch (IOException e) {
            throw new SearchException(ELEMENT_EXECUTION_ERROR_MESSAGE, e);
        }
        return Objects.isNull(response) ? Collections.emptyList() : Arrays.stream(response.hits().hits().toArray()).map(hit -> ((InnerHitsResult)((Hit)hit).innerHits().get(INNER_HIT_NAME)).hits().hits()).flatMap(Collection::stream).map(hit -> (SessionElementElastic)((JsonData)hit.source()).to(SessionElementElastic.class)).toList();
    }

    private void delete(DeleteByQueryRequest request) {
        try {
            this.openSearchClientSupplier.getClient().deleteByQuery(request);
        }
        catch (IOException e) {
            throw new SearchException("Unable to perform delete from OpenSearch", e);
        }
    }
}

