/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.sessions.service;

import java.util.Map;
import java.util.Set;
import org.qubership.integration.platform.sessions.properties.InternalServicesProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class CatalogInternalService {
    private static final Logger log = LoggerFactory.getLogger(CatalogInternalService.class);
    private static final String CATALOG_REST_PROTOCOL = "http";
    private static final String CATALOG_PORT = "8080";
    private static final String CATALOG_GET_CHAINS_NAMES = "/v1/chains/names?chainIds={chainIds}";
    private final String catalogUrl;
    private final RestTemplate restTemplateMS;

    public CatalogInternalService(RestTemplate restTemplateMS, InternalServicesProperties internalServicesProperties) {
        this.restTemplateMS = restTemplateMS;
        this.catalogUrl = "http://" + internalServicesProperties.designtimeCatalog() + ":8080";
    }

    public Map<String, String> getChainsNames(Set<String> chainIds) {
        String address = this.catalogUrl + CATALOG_GET_CHAINS_NAMES;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity entity = new HttpEntity(null, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplateMS.exchange(address, HttpMethod.GET, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<Map<String, String>>(){}, new Object[]{String.join((CharSequence)",", chainIds)});
        if (!response.getStatusCode().is2xxSuccessful() || response.getBody() == null) {
            log.error("Failed to request chains names from catalog, response with non 2xx code: {}, {}", (Object)response.getStatusCode(), response.getBody());
            throw new RuntimeException("Failed to request chains names from catalog, response with non 2xx code");
        }
        return (Map)response.getBody();
    }
}

