/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.kafka.security.oauthbearer;

import java.net.URISyntaxException;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import org.qubership.kafka.security.oauthbearer.OAuthLoginUtils;
import org.qubership.kafka.security.oauthbearer.TokenRetriever;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthTokenRetriever
implements TokenRetriever {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuthTokenRetriever.class);
    private static final String CLIENT_ID_OPTION = "clientId";
    private static final String CLIENT_SECRET_OPTION = "clientSecret";
    private static final String TOKEN_ENDPOINT_OPTION = "tokenEndpoint";
    private Client client;
    private String tokenEndpoint;
    private String clientId;
    private String clientSecret;

    @Override
    public void configure(Map<String, String> options) {
        this.client = OAuthLoginUtils.createClient(LOGGER);
        this.tokenEndpoint = this.getTokenEndpoint(options);
        this.clientId = options.get(CLIENT_ID_OPTION);
        this.clientSecret = options.get(CLIENT_SECRET_OPTION);
    }

    @Override
    public boolean isConfigured() {
        if (this.tokenEndpoint == null || this.clientId == null || this.clientSecret == null) {
            LOGGER.debug("This login cannot be used to establish client connections");
            return false;
        }
        return true;
    }

    @Nullable
    private String getTokenEndpoint(@Nonnull Map<String, String> options) {
        String tokenEndpoint = options.get(TOKEN_ENDPOINT_OPTION);
        if (tokenEndpoint == null || tokenEndpoint.isEmpty()) {
            return null;
        }
        try {
            return OAuthLoginUtils.normalizeUrl(tokenEndpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("Invalid token endpoint: %s", tokenEndpoint), e);
        }
    }

    @Override
    public String retrieveAccessToken() {
        WebTarget webTarget = this.client.target(this.tokenEndpoint);
        Form form = new Form();
        form.param("grant_type", "client_credentials");
        Invocation.Builder invocationBuilder = webTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        invocationBuilder.header("Authorization", (Object)("Basic " + OAuthLoginUtils.clientCredentials(this.clientId, this.clientSecret)));
        Entity entity = Entity.entity((Object)form, (String)"application/x-www-form-urlencoded");
        Map response = (Map)invocationBuilder.post(entity, Map.class);
        Objects.requireNonNull(response, () -> String.format("Token endpoint cannot be obtained: invalid response from: %s", this.tokenEndpoint));
        String res = (String)response.get("access_token");
        return res;
    }

    @Override
    public String getIdpEndpoint() {
        return this.tokenEndpoint;
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }
}

