/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.kafka.security.oauthbearer;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;

abstract class AbstractOAuthBearerCallbackHandler
implements AuthenticateCallbackHandler {
    private boolean configured = false;

    AbstractOAuthBearerCallbackHandler() {
    }

    void throwExceptionIfNotConfigured() {
        if (!this.configured) {
            throw new IllegalStateException("Callback handler not configured");
        }
    }

    public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        if (!"OAUTHBEARER".equals(saslMechanism)) {
            throw new IllegalArgumentException(String.format("Unexpected SASL mechanism: %s", saslMechanism));
        }
        if (Objects.requireNonNull(jaasConfigEntries).size() != 1 || jaasConfigEntries.get(0) == null) {
            throw new IllegalArgumentException(String.format("Must supply exactly 1 non-null JAAS mechanism configuration (size was %d)", jaasConfigEntries.size()));
        }
        Map<String, ?> options = jaasConfigEntries.get(0).getOptions();
        this.configureOptions(Collections.unmodifiableMap(options));
        this.configured = true;
    }

    abstract void configureOptions(@Nonnull Map<String, String> var1);

    public void close() {
    }
}

