/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.kafka.security.oauthbearer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import java.io.IOException;
import java.text.ParseException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONObject;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OAuthBearerJwt
implements OAuthBearerToken {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuthBearerJwt.class);
    public static final String POINT = ".";
    public static final String SPACE = " ";
    public static final String SLASH = "/";
    private static final ObjectMapper OM = new ObjectMapper();
    @Nonnull
    private final String value;
    @Nonnull
    private final Set<String> scope;
    private final long lifetimeMs;
    @Nonnull
    private final String principalName;
    @Nullable
    private final Long startTimeMs;
    @Nonnull
    private final JWSHeader header;
    @Nonnull
    private final JSONObject payload;
    @Nonnull
    private final Set<String> roles;

    public OAuthBearerJwt(@Nonnull String token) {
        this(token, "");
    }

    OAuthBearerJwt(@Nonnull String token, @Nonnull String tokenRolesPath) {
        JWSObject jwsToken;
        this.value = Objects.requireNonNull(token);
        try {
            jwsToken = JWSObject.parse((String)this.value);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Token does not have JWT-token structure", e);
        }
        this.header = jwsToken.getHeader();
        Map initialPayload = jwsToken.getPayload().toJSONObject();
        if (initialPayload == null) {
            throw new IllegalArgumentException("JWT Token does not have payload.");
        }
        this.payload = new JSONObject(initialPayload);
        Object scope = this.payload.get((Object)"scope");
        if (scope instanceof List) {
            HashSet<String> scopes = new HashSet<String>();
            for (Object item : (List)scope) {
                scopes.add((String)item);
            }
            this.scope = Collections.unmodifiableSet(scopes);
        } else {
            this.scope = scope == null ? Collections.emptySet() : Collections.singleton((String)scope);
        }
        this.roles = this.calculateRoles(tokenRolesPath);
        this.lifetimeMs = Instant.ofEpochSecond(this.payload.getAsNumber("exp").longValue()).toEpochMilli();
        this.principalName = this.payload.getAsString("sub");
        Number startTimeMs = this.payload.getAsNumber("iat");
        this.startTimeMs = startTimeMs == null ? null : Long.valueOf(Instant.ofEpochSecond(startTimeMs.longValue()).toEpochMilli());
    }

    public String value() {
        return this.value;
    }

    public Set<String> scope() {
        return this.scope;
    }

    public long lifetimeMs() {
        return this.lifetimeMs;
    }

    public String principalName() {
        return this.principalName;
    }

    public Long startTimeMs() {
        return this.startTimeMs;
    }

    public Set<String> roles() {
        return this.roles;
    }

    @Nonnull
    JWSAlgorithm algorithm() {
        return this.header.getAlgorithm();
    }

    @Nonnull
    String issuer() {
        return this.payload.getAsString("iss");
    }

    private Set<String> calculateRoles(String tokenRolesPath) {
        JsonNode roles = this.getNodeByPath(tokenRolesPath);
        if (roles instanceof ArrayNode) {
            HashSet<String> elements = new HashSet<String>();
            for (int i = 0; i < roles.size(); ++i) {
                elements.add(roles.get(i).textValue());
            }
            return Collections.unmodifiableSet(elements);
        }
        if (roles instanceof TextNode) {
            String[] rolesAsArray = roles.textValue().split(SPACE);
            HashSet<String> elements = new HashSet<String>(Arrays.asList(rolesAsArray));
            return Collections.unmodifiableSet(elements);
        }
        return Collections.emptySet();
    }

    private JsonNode getNodeByPath(String path) {
        try {
            JsonNode node = OM.readTree(this.payload.toJSONString());
            return node.at(SLASH + path.replace(POINT, SLASH));
        }
        catch (IOException e) {
            LOGGER.error("Cannot read tree from JSON", (Throwable)e);
            return null;
        }
    }
}

