/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.kafka.security.oauthbearer;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenCallback;
import org.qubership.kafka.security.oauthbearer.AbstractOAuthBearerCallbackHandler;
import org.qubership.kafka.security.oauthbearer.OAuthBearerJwt;
import org.qubership.kafka.security.oauthbearer.OAuthTokenRetriever;
import org.qubership.kafka.security.oauthbearer.TokenRetriever;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthBearerLoginCallbackHandler
extends AbstractOAuthBearerCallbackHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuthBearerLoginCallbackHandler.class);
    private final TokenRetriever retriever;

    public OAuthBearerLoginCallbackHandler() {
        this(new OAuthTokenRetriever());
    }

    public OAuthBearerLoginCallbackHandler(TokenRetriever retriever) {
        this.retriever = retriever;
    }

    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        this.throwExceptionIfNotConfigured();
        for (Callback callback : callbacks) {
            OAuthBearerTokenCallback tokenCallback;
            if (callback instanceof OAuthBearerTokenCallback) {
                tokenCallback = (OAuthBearerTokenCallback)callback;
                if (tokenCallback.token() != null) {
                    throw new IllegalArgumentException("Callback had a token already");
                }
            } else {
                throw new UnsupportedCallbackException(callback);
            }
            tokenCallback.token(this.retrieveToken());
        }
    }

    @Nullable
    private OAuthBearerToken retrieveToken() {
        if (!this.retriever.isConfigured()) {
            return null;
        }
        String accessToken = this.retriever.retrieveAccessToken();
        if (accessToken == null) {
            throw new IllegalStateException(String.format("Access token not retrieved from: %s", this.retriever.getIdpEndpoint()));
        }
        OAuthBearerJwt jwt = new OAuthBearerJwt(accessToken);
        LOGGER.info("Retrieved token with principal: {}", (Object)jwt.principalName());
        return jwt;
    }

    @Override
    void configureOptions(@Nonnull Map<String, String> options) {
        this.retriever.configure(options);
    }

    @Override
    public void close() {
        this.retriever.close();
    }
}

