/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.kafka.security.oauthbearer;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import org.qubership.kafka.security.oauthbearer.OAuthLoginUtils;
import org.qubership.kafka.security.oauthbearer.TokenRetriever;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VaultOAuthTokenRetriever
implements TokenRetriever {
    private static final Logger LOGGER = LoggerFactory.getLogger(VaultOAuthTokenRetriever.class);
    private static final String VAULT_ENDPOINT_OPTION = "vaultUrl";
    private static final String VAULT_ROLE_PATH_OPTION = "vaultRolePath";
    private static final String VAULT_AUTH_ROLE_OPTION = "vaultAuthRole";
    private static final String KUBERNETES_SERVICE_ACCOUNT_TOKEN_PATH = "/var/run/secrets/kubernetes.io/serviceaccount/token";
    private static final String KUBERNETES_SERVICE_ACCOUNT_TOKEN_KEY = "KUBERNETES_SERVICE_ACCOUNT_TOKEN";
    private Client client;
    private WebTarget vaultWebTarget;
    private String vaultRolePath;
    private String vaultAuthRole;

    @Override
    public void configure(Map<String, String> options) {
        this.client = OAuthLoginUtils.createClient(LOGGER);
        String vaultUrl = options.get(VAULT_ENDPOINT_OPTION);
        this.vaultWebTarget = this.client.target(vaultUrl);
        this.vaultRolePath = options.get(VAULT_ROLE_PATH_OPTION);
        this.vaultAuthRole = options.get(VAULT_AUTH_ROLE_OPTION);
    }

    @Override
    public boolean isConfigured() {
        return this.vaultRolePath != null && this.vaultAuthRole != null;
    }

    @Override
    public String retrieveAccessToken() {
        String vaultToken = this.login();
        WebTarget oidcWebTarget = this.vaultWebTarget.path("v1/identity/oidc/token/{oidc_role_path}").resolveTemplate("oidc_role_path", (Object)this.vaultRolePath);
        Invocation.Builder invocationBuilder = oidcWebTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        invocationBuilder.header("X-Vault-Token", (Object)vaultToken);
        Map response = (Map)invocationBuilder.get(Map.class);
        return (String)((Map)response.get("data")).get("token");
    }

    private String login() {
        WebTarget loginWebTarget = this.vaultWebTarget.path("v1/auth/kubernetes/login");
        Invocation.Builder invocationBuilder = loginWebTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        final String jwt = this.getServiceAccountJwt();
        HashMap<String, String> loginBody = new HashMap<String, String>(){
            {
                this.put("jwt", jwt);
                this.put("role", VaultOAuthTokenRetriever.this.vaultAuthRole);
            }
        };
        Map response = (Map)invocationBuilder.post(Entity.json((Object)loginBody), Map.class);
        return (String)((Map)response.get("auth")).get("client_token");
    }

    private String getServiceAccountJwt() {
        String jwt = System.getenv(KUBERNETES_SERVICE_ACCOUNT_TOKEN_KEY);
        if (jwt == null || jwt.isEmpty()) {
            try {
                jwt = new String(Files.readAllBytes(Paths.get(KUBERNETES_SERVICE_ACCOUNT_TOKEN_PATH, new String[0])));
            }
            catch (IOException e) {
                LOGGER.error("Can not read service account token from inner Pod file", (Throwable)e);
            }
        }
        Objects.requireNonNull(jwt, "Can not get kubernetes service account jwt token");
        return jwt;
    }

    @Override
    public String getIdpEndpoint() {
        return this.vaultWebTarget.getUri().toString();
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }
}

