/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.kafka.security.audit;

import java.util.Map;
import javax.annotation.Nonnull;
import org.qubership.kafka.security.audit.CEFSettingsFromXML;
import org.qubership.kafka.security.audit.history.CEFHistoryRecord;
import org.qubership.kafka.security.audit.history.CEFLog4jHistoryWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditRecordWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditRecordWriter.class);
    private static final AuditRecordWriter INSTANCE = new AuditRecordWriter();
    private static final String AUDIT_LOGS_ENABLED = "auditLogsEnabled";
    private static final String AUDIT_LOGS_ENABLED_DEFAULT_VALUE = "false";
    private static final String AUDIT_CEF_CONFIG_PATH = "auditCefConfigPath";
    private static final String AUDIT_CEF_CONFIG_PATH_DEFAULT = "/opt/kafka/config/cef-configuration.xml";
    private CEFLog4jHistoryWriter cefLog4jAuditWriter;
    private boolean isAuditEnabled;
    private boolean isConfigured;

    public static AuditRecordWriter getInstance() {
        return INSTANCE;
    }

    public void configure(@Nonnull Map<String, String> options) {
        this.isAuditEnabled = Boolean.parseBoolean(options.getOrDefault(AUDIT_LOGS_ENABLED, AUDIT_LOGS_ENABLED_DEFAULT_VALUE));
        String cefConfigFilePath = options.getOrDefault(AUDIT_CEF_CONFIG_PATH, AUDIT_CEF_CONFIG_PATH_DEFAULT);
        this.cefLog4jAuditWriter = this.isAuditEnabled ? new CEFLog4jHistoryWriter(new CEFSettingsFromXML(cefConfigFilePath)) : null;
        this.isConfigured = true;
        LOGGER.info("Audit Logging is {}", (Object)(this.isAuditEnabled ? "enabled" : "disabled"));
    }

    public void trackAuditEvent(CEFHistoryRecord auditRecord) {
        if (!this.isConfigured) {
            LOGGER.warn("Can't track audit log because AuditRecordWriter is not configured yet");
            return;
        }
        if (this.isAuditEnabled) {
            this.cefLog4jAuditWriter.write(auditRecord);
        }
    }
}

