/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.kafka.security.audit;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.qubership.kafka.security.audit.history.CEFConfiguration;
import org.qubership.kafka.security.audit.history.CEFSettings;
import org.qubership.kafka.security.audit.history.SeverityNode;

public class CEFSettingsFromXML
implements CEFSettings {
    private static final String DEFAULT_CEF_CONFIGURATION_PATH = "/config/cef/cef-configuration-default.xml";
    private final CEFConfiguration cefConfiguration;
    private final Map<String, Integer> severityMap;

    CEFSettingsFromXML(String cefConfigFilePath) {
        this.cefConfiguration = this.loadConfiguration(cefConfigFilePath);
        this.severityMap = this.loadSeverityMap(this.cefConfiguration);
    }

    @Override
    public int getCEFVersion() {
        return this.cefConfiguration.getCEFVersion();
    }

    @Override
    public String getDeviceVendor() {
        return this.cefConfiguration.getDeviceVendor();
    }

    @Override
    public String getDeviceProduct() {
        return this.cefConfiguration.getDeviceProduct();
    }

    @Override
    public String getDeviceVersion() {
        return this.cefConfiguration.getDeviceVersion();
    }

    @Override
    public Map<String, Integer> getSeverityMap() {
        return this.severityMap;
    }

    private CEFConfiguration loadConfiguration(String cefConfigFilePath) {
        try {
            File cefConfigFile = new File(cefConfigFilePath);
            InputStream configurationSource = cefConfigFile.exists() ? new FileInputStream(cefConfigFile) : this.getClass().getResourceAsStream(DEFAULT_CEF_CONFIGURATION_PATH);
            Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{CEFConfiguration.class}).createUnmarshaller();
            return (CEFConfiguration)unmarshaller.unmarshal(configurationSource);
        }
        catch (FileNotFoundException | JAXBException e) {
            throw new RuntimeException("Cannot load CEF Configuration from XML", e);
        }
    }

    private Map<String, Integer> loadSeverityMap(CEFConfiguration cefConfiguration) {
        List<SeverityNode> severityNodes = cefConfiguration.getSeverityMap().getSeverityNode();
        HashMap<String, Integer> severityMap = new HashMap<String, Integer>(severityNodes.size(), 1.0f);
        for (SeverityNode severityNode : severityNodes) {
            severityMap.put(severityNode.getEventSignature(), severityNode.getSeverity());
        }
        return severityMap;
    }
}

